/*
 * Decompiled with CFR 0.152.
 */
package forestry.apiculture.compat;

import forestry.apiculture.features.ApicultureItems;
import forestry.core.utils.JeiUtil;
import forestry.modules.ModuleHelper;
import genetics.api.GeneticHelper;
import java.util.Optional;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.ingredients.subtypes.ISubtypeInterpreter;
import mezz.jei.api.registration.IRecipeRegistration;
import mezz.jei.api.registration.ISubtypeRegistration;
import net.minecraft.item.Item;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
@JeiPlugin
public class ApicultureJeiPlugin
implements IModPlugin {
    public ResourceLocation getPluginUid() {
        return new ResourceLocation("forestry");
    }

    public void registerItemSubtypes(ISubtypeRegistration subtypeRegistry) {
        if (!ModuleHelper.isEnabled("apiculture")) {
            return;
        }
        ISubtypeInterpreter beeSubtypeInterpreter = itemStack -> {
            Optional individual = GeneticHelper.getIndividual(itemStack);
            return individual.map(iIndividual -> iIndividual.getGenome().getPrimary().getBinomial()).orElse("");
        };
        subtypeRegistry.registerSubtypeInterpreter(ApicultureItems.BEE_DRONE.item(), beeSubtypeInterpreter);
        subtypeRegistry.registerSubtypeInterpreter(ApicultureItems.BEE_PRINCESS.item(), beeSubtypeInterpreter);
        subtypeRegistry.registerSubtypeInterpreter(ApicultureItems.BEE_QUEEN.item(), beeSubtypeInterpreter);
        subtypeRegistry.registerSubtypeInterpreter(ApicultureItems.BEE_LARVAE.item(), beeSubtypeInterpreter);
    }

    public void registerRecipes(IRecipeRegistration registry) {
        if (!ModuleHelper.isEnabled("apiculture")) {
            return;
        }
        JeiUtil.addDescription(registry, "frames", ApicultureItems.FRAME_IMPREGNATED.getItem(), ApicultureItems.FRAME_PROVEN.getItem(), ApicultureItems.FRAME_UNTREATED.getItem());
        JeiUtil.addDescription(registry, "apiarist.suit", new Item[]{ApicultureItems.APIARIST_BOOTS.getItem(), ApicultureItems.APIARIST_CHEST.getItem(), ApicultureItems.APIARIST_HELMET.getItem(), ApicultureItems.APIARIST_LEGS.getItem()});
        JeiUtil.addDescription(registry, ApicultureItems.HABITAT_LOCATOR.getItem(), ApicultureItems.SCOOP.getItem(), ApicultureItems.IMPRINTER.getItem());
    }
}

