/*
 * Decompiled with CFR 0.152.
 */
package forestry.apiculture.entities;

import forestry.api.apiculture.IBeeHousingInventory;
import forestry.api.apiculture.IBeeListener;
import forestry.api.apiculture.IBeeModifier;
import forestry.api.apiculture.hives.IHiveFrame;
import forestry.apiculture.ApiaryBeeListener;
import forestry.apiculture.ApiaryBeeModifier;
import forestry.apiculture.IApiary;
import forestry.apiculture.blocks.BlockTypeApiculture;
import forestry.apiculture.entities.MinecartEntityBeeHousingBase;
import forestry.apiculture.features.ApicultureBlocks;
import forestry.apiculture.features.ApicultureEntities;
import forestry.apiculture.features.ApicultureItems;
import forestry.apiculture.gui.ContainerMinecartBeehouse;
import forestry.apiculture.gui.GuiBeeHousing;
import forestry.apiculture.inventory.IApiaryInventory;
import forestry.apiculture.inventory.InventoryApiary;
import forestry.apiculture.items.ItemMinecartBeehousing;
import forestry.core.inventory.IInventoryAdapter;
import forestry.core.network.PacketBufferForestry;
import forestry.modules.features.FeatureBlock;
import forestry.modules.features.FeatureItem;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import net.minecraft.block.BlockState;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Tuple;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.NetworkHooks;

public class MinecartEntityApiary
extends MinecartEntityBeeHousingBase
implements IApiary {
    private static final IBeeModifier beeModifier = new ApiaryBeeModifier();
    private final IBeeListener beeListener = new ApiaryBeeListener(this);
    private final InventoryApiary inventory = new InventoryApiary();

    public MinecartEntityApiary(EntityType<? extends MinecartEntityApiary> type, World world) {
        super((EntityType<? extends MinecartEntityBeeHousingBase>)type, world);
    }

    public MinecartEntityApiary(World world, double posX, double posY, double posZ) {
        super(ApicultureEntities.APIARY_MINECART.entityType(), world, posX, posY, posZ);
    }

    @Override
    public String getHintKey() {
        return "apiary";
    }

    @Override
    protected IInventoryAdapter getInternalInventory() {
        return this.inventory;
    }

    @Override
    public IApiaryInventory getApiaryInventory() {
        return this.inventory;
    }

    @Override
    public IBeeHousingInventory getBeeInventory() {
        return this.inventory;
    }

    @Override
    public BlockState func_174897_t() {
        return ((FeatureBlock)ApicultureBlocks.BASE.get(BlockTypeApiculture.APIARY)).defaultState();
    }

    @Override
    public ItemStack getCartItem() {
        return ((FeatureItem)ApicultureItems.MINECART_BEEHOUSING.get(ItemMinecartBeehousing.Type.APIARY)).stack();
    }

    public Collection<IBeeModifier> getBeeModifiers() {
        ArrayList<IBeeModifier> beeModifiers = new ArrayList<IBeeModifier>();
        beeModifiers.add(beeModifier);
        for (Tuple<IHiveFrame, ItemStack> frame : this.inventory.getFrames()) {
            IHiveFrame hiveFrame = (IHiveFrame)frame.func_76341_a();
            ItemStack stack = (ItemStack)frame.func_76340_b();
            IBeeModifier beeModifier = hiveFrame.getBeeModifier(stack);
            beeModifiers.add(beeModifier);
        }
        return beeModifiers;
    }

    @Override
    public Iterable<IBeeListener> getBeeListeners() {
        return Collections.singleton(this.beeListener);
    }

    public Container createMenu(int windowId, PlayerInventory inv, PlayerEntity player) {
        return new ContainerMinecartBeehouse(windowId, player.field_71071_by, this, true, GuiBeeHousing.Icon.APIARY);
    }

    @Override
    protected void openGui(ServerPlayerEntity player) {
        NetworkHooks.openGui((ServerPlayerEntity)player, (INamedContainerProvider)this, p -> {
            PacketBufferForestry fP = new PacketBufferForestry((ByteBuf)p);
            fP.writeEntityById(this.getEntity());
            fP.writeBoolean(true);
            fP.writeEnum(GuiBeeHousing.Icon.APIARY, GuiBeeHousing.Icon.values());
        });
    }
}

