/*
 * Decompiled with CFR 0.152.
 */
package forestry.apiculture.flowers;

import forestry.api.genetics.ICheckPollinatable;
import forestry.api.genetics.flowers.IFlowerProvider;
import genetics.api.individual.IIndividual;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.common.PlantType;

public class FlowerProvider
implements IFlowerProvider {
    private final String flowerType;
    private final String unlocalizedDescription;

    public FlowerProvider(String flowerType, String unlocalizedDescription) {
        this.flowerType = flowerType;
        this.unlocalizedDescription = unlocalizedDescription;
    }

    @Override
    public String getFlowerType() {
        return this.flowerType;
    }

    @Override
    public boolean isAcceptedPollinatable(World world, ICheckPollinatable pollinatable) {
        PlantType plantType = pollinatable.getPlantType();
        switch (this.flowerType) {
            case "flowersNether": {
                return plantType == PlantType.NETHER;
            }
            case "flowersCacti": {
                return plantType == PlantType.DESERT;
            }
        }
        return plantType != PlantType.NETHER;
    }

    @Override
    public ITextComponent getDescription() {
        return new TranslationTextComponent(this.unlocalizedDescription);
    }

    @Override
    public NonNullList<ItemStack> affectProducts(World world, IIndividual individual, BlockPos pos, NonNullList<ItemStack> products) {
        return products;
    }
}

