/*
 * Decompiled with CFR 0.152.
 */
package forestry.apiculture.genetics;

import com.mojang.blaze3d.matrix.MatrixStack;
import forestry.api.apiculture.BeeManager;
import forestry.api.apiculture.genetics.BeeChromosomes;
import forestry.api.apiculture.genetics.EnumBeeType;
import forestry.api.apiculture.genetics.IAlleleBeeSpecies;
import forestry.api.apiculture.genetics.IBee;
import forestry.api.genetics.EnumTolerance;
import forestry.api.genetics.IAlyzerPlugin;
import forestry.api.genetics.alleles.AlleleManager;
import forestry.apiculture.features.ApicultureItems;
import forestry.apiculture.items.ItemBeeGE;
import forestry.core.config.Config;
import forestry.core.gui.GuiAlyzer;
import forestry.core.gui.TextLayoutHelper;
import forestry.core.gui.widgets.ItemStackWidget;
import forestry.core.gui.widgets.WidgetManager;
import forestry.core.utils.StringUtil;
import forestry.core.utils.Translator;
import genetics.api.GeneticHelper;
import genetics.api.alleles.IAlleleValue;
import genetics.api.individual.IGenome;
import genetics.api.organism.IOrganism;
import genetics.api.organism.IOrganismType;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class BeeAlyzerPlugin
implements IAlyzerPlugin {
    public static final BeeAlyzerPlugin INSTANCE = new BeeAlyzerPlugin();
    protected final Map<ResourceLocation, ItemStack> iconStacks = new HashMap<ResourceLocation, ItemStack>();

    private BeeAlyzerPlugin() {
        NonNullList beeList = NonNullList.func_191196_a();
        ((ItemBeeGE)ApicultureItems.BEE_DRONE.item()).addCreativeItems((NonNullList<ItemStack>)beeList, false);
        for (ItemStack beeStack : beeList) {
            IOrganism organism = GeneticHelper.getOrganism(beeStack);
            if (organism.isEmpty()) continue;
            IAlleleBeeSpecies species = organism.getAllele(BeeChromosomes.SPECIES, true);
            this.iconStacks.put(species.getRegistryName(), beeStack);
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void drawAnalyticsPage1(MatrixStack transform, Screen gui, ItemStack itemStack) {
        if (gui instanceof GuiAlyzer) {
            GuiAlyzer guiAlyzer = (GuiAlyzer)gui;
            Optional optional = BeeManager.beeRoot.create(itemStack);
            if (!optional.isPresent()) {
                return;
            }
            IBee bee = (IBee)optional.get();
            Optional<IOrganismType> typeOptional = BeeManager.beeRoot.getTypes().getType(itemStack);
            if (!typeOptional.isPresent()) {
                return;
            }
            IOrganismType type = typeOptional.get();
            TextLayoutHelper textLayout = guiAlyzer.getTextLayout();
            textLayout.startPage(12, 90, 155);
            textLayout.drawLine(transform, Translator.translateToLocal("for.gui.active"), 90);
            textLayout.drawLine(transform, Translator.translateToLocal("for.gui.inactive"), 155);
            textLayout.newLine();
            textLayout.newLine();
            guiAlyzer.drawSpeciesRow(transform, Translator.translateToLocal("for.gui.species"), bee, BeeChromosomes.SPECIES, type);
            textLayout.newLine();
            guiAlyzer.drawChromosomeRow(transform, Translator.translateToLocal("for.gui.lifespan"), bee, BeeChromosomes.LIFESPAN);
            textLayout.newLine();
            guiAlyzer.drawChromosomeRow(transform, Translator.translateToLocal("for.gui.speed"), bee, BeeChromosomes.SPEED);
            textLayout.newLine();
            guiAlyzer.drawChromosomeRow(transform, Translator.translateToLocal("for.gui.pollination"), bee, BeeChromosomes.FLOWERING);
            textLayout.newLine();
            guiAlyzer.drawChromosomeRow(transform, Translator.translateToLocal("for.gui.flowers"), bee, BeeChromosomes.FLOWER_PROVIDER);
            textLayout.newLine();
            textLayout.drawLine(transform, Translator.translateToLocal("for.gui.fertility"), 12);
            IAlleleValue<Integer> primaryFertility = bee.getGenome().getActiveAllele(BeeChromosomes.FERTILITY);
            IAlleleValue<Integer> secondaryFertility = bee.getGenome().getInactiveAllele(BeeChromosomes.FERTILITY);
            guiAlyzer.drawFertilityInfo(transform, primaryFertility.getValue(), 90, guiAlyzer.getColorCoding(primaryFertility.isDominant()), 0);
            guiAlyzer.drawFertilityInfo(transform, secondaryFertility.getValue(), 155, guiAlyzer.getColorCoding(secondaryFertility.isDominant()), 0);
            textLayout.newLine();
            guiAlyzer.drawChromosomeRow(transform, Translator.translateToLocal("for.gui.area"), bee, BeeChromosomes.TERRITORY);
            textLayout.newLine();
            guiAlyzer.drawChromosomeRow(transform, Translator.translateToLocal("for.gui.effect"), bee, BeeChromosomes.EFFECT);
            textLayout.newLine();
            textLayout.endPage();
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void drawAnalyticsPage2(MatrixStack transform, Screen gui, ItemStack itemStack) {
        if (gui instanceof GuiAlyzer) {
            String displayText;
            String nocturnal1;
            String diurnal1;
            String nocturnal0;
            String diurnal0;
            GuiAlyzer guiAlyzer = (GuiAlyzer)gui;
            Optional optional = BeeManager.beeRoot.create(itemStack);
            if (!optional.isPresent()) {
                return;
            }
            IBee bee = (IBee)optional.get();
            Optional<IOrganismType> typeOptional = BeeManager.beeRoot.getTypes().getType(itemStack);
            if (!typeOptional.isPresent()) {
                return;
            }
            IOrganismType type = typeOptional.get();
            IGenome genome = bee.getGenome();
            IAlleleBeeSpecies primaryAllele = genome.getActiveAllele(BeeChromosomes.SPECIES);
            IAlleleBeeSpecies secondaryAllele = genome.getActiveAllele(BeeChromosomes.SPECIES);
            TextLayoutHelper textLayout = guiAlyzer.getTextLayout();
            textLayout.startPage(12, 90, 155);
            textLayout.drawLine(transform, Translator.translateToLocal("for.gui.active"), 90);
            textLayout.drawLine(transform, Translator.translateToLocal("for.gui.inactive"), 155);
            textLayout.newLine();
            guiAlyzer.drawRow(transform, Translator.translateToLocal("for.gui.climate"), AlleleManager.climateHelper.toDisplay(primaryAllele.getTemperature()).getString(), AlleleManager.climateHelper.toDisplay(secondaryAllele.getTemperature()).getString(), bee, BeeChromosomes.SPECIES);
            textLayout.newLine();
            IAlleleValue<EnumTolerance> tempToleranceActive = bee.getGenome().getActiveAllele(BeeChromosomes.TEMPERATURE_TOLERANCE);
            IAlleleValue<EnumTolerance> tempToleranceInactive = bee.getGenome().getInactiveAllele(BeeChromosomes.TEMPERATURE_TOLERANCE);
            textLayout.drawLine(transform, "  " + Translator.translateToLocal("for.gui.tolerance"), 12);
            guiAlyzer.drawToleranceInfo(transform, tempToleranceActive, 90);
            guiAlyzer.drawToleranceInfo(transform, tempToleranceInactive, 155);
            textLayout.newLine(16);
            guiAlyzer.drawRow(transform, Translator.translateToLocal("for.gui.humidity"), AlleleManager.climateHelper.toDisplay(primaryAllele.getHumidity()).getString(), AlleleManager.climateHelper.toDisplay(secondaryAllele.getHumidity()).getString(), bee, BeeChromosomes.SPECIES);
            textLayout.newLine();
            IAlleleValue<EnumTolerance> humidToleranceActive = bee.getGenome().getActiveAllele(BeeChromosomes.HUMIDITY_TOLERANCE);
            IAlleleValue<EnumTolerance> humidToleranceInactive = bee.getGenome().getInactiveAllele(BeeChromosomes.HUMIDITY_TOLERANCE);
            textLayout.drawLine(transform, "  " + Translator.translateToLocal("for.gui.tolerance"), 12);
            guiAlyzer.drawToleranceInfo(transform, humidToleranceActive, 90);
            guiAlyzer.drawToleranceInfo(transform, humidToleranceInactive, 155);
            textLayout.newLine(16);
            String yes = Translator.translateToLocal("for.yes");
            String no = Translator.translateToLocal("for.no");
            if (genome.getActiveValue(BeeChromosomes.NEVER_SLEEPS).booleanValue()) {
                nocturnal0 = diurnal0 = yes;
            } else {
                nocturnal0 = primaryAllele.isNocturnal() ? yes : no;
                String string = diurnal0 = !primaryAllele.isNocturnal() ? yes : no;
            }
            if (genome.getInactiveValue(BeeChromosomes.NEVER_SLEEPS).booleanValue()) {
                nocturnal1 = diurnal1 = yes;
            } else {
                nocturnal1 = secondaryAllele.isNocturnal() ? yes : no;
                diurnal1 = !secondaryAllele.isNocturnal() ? yes : no;
            }
            textLayout.drawLine(transform, Translator.translateToLocal("for.gui.diurnal"), 12);
            textLayout.drawLine(transform, diurnal0, 90, guiAlyzer.getColorCoding(false));
            textLayout.drawLine(transform, diurnal1, 155, guiAlyzer.getColorCoding(false));
            textLayout.newLineCompressed();
            textLayout.drawLine(transform, Translator.translateToLocal("for.gui.nocturnal"), 12);
            textLayout.drawLine(transform, nocturnal0, 90, guiAlyzer.getColorCoding(false));
            textLayout.drawLine(transform, nocturnal1, 155, guiAlyzer.getColorCoding(false));
            textLayout.newLineCompressed();
            String primary = StringUtil.readableBoolean(genome.getActiveValue(BeeChromosomes.TOLERATES_RAIN), yes, no);
            String secondary = StringUtil.readableBoolean(genome.getInactiveValue(BeeChromosomes.TOLERATES_RAIN), yes, no);
            guiAlyzer.drawRow(transform, Translator.translateToLocal("for.gui.flyer"), primary, secondary, bee, BeeChromosomes.TOLERATES_RAIN);
            textLayout.newLineCompressed();
            primary = StringUtil.readableBoolean(genome.getActiveValue(BeeChromosomes.CAVE_DWELLING), yes, no);
            secondary = StringUtil.readableBoolean(genome.getInactiveValue(BeeChromosomes.CAVE_DWELLING), yes, no);
            guiAlyzer.drawRow(transform, Translator.translateToLocal("for.gui.cave"), primary, secondary, bee, BeeChromosomes.CAVE_DWELLING);
            textLayout.newLine();
            if (type == EnumBeeType.PRINCESS || type == EnumBeeType.QUEEN) {
                String displayTextKey = "for.bees.stock.pristine";
                if (!bee.isNatural()) {
                    displayTextKey = "for.bees.stock.ignoble";
                }
                displayText = Translator.translateToLocal(displayTextKey);
                textLayout.drawCenteredLine(transform, displayText, 8, 208, guiAlyzer.getFontColor().get("gui.beealyzer.binomial"));
            }
            if (bee.getGeneration() >= 0) {
                textLayout.newLineCompressed();
                displayText = Translator.translateToLocalFormatted("for.gui.beealyzer.generations", bee.getGeneration());
                textLayout.drawCenteredLine(transform, displayText, 8, 208, guiAlyzer.getFontColor().get("gui.beealyzer.binomial"));
            }
            textLayout.endPage();
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void drawAnalyticsPage3(MatrixStack transform, ItemStack itemStack, Screen gui) {
        if (gui instanceof GuiAlyzer) {
            GuiAlyzer guiAlyzer = (GuiAlyzer)gui;
            Optional optional = BeeManager.beeRoot.create(itemStack);
            if (!optional.isPresent()) {
                return;
            }
            IBee bee = (IBee)optional.get();
            TextLayoutHelper textLayout = guiAlyzer.getTextLayout();
            WidgetManager widgetManager = guiAlyzer.getWidgetManager();
            textLayout.startPage(12, 90, 155);
            textLayout.drawLine(transform, Translator.translateToLocal("for.gui.beealyzer.produce") + ":", 12);
            textLayout.newLine();
            int x = 12;
            for (ItemStack stack : bee.getProduceList()) {
                widgetManager.add(new ItemStackWidget(widgetManager, x, textLayout.getLineY(), stack));
                if ((x += 18) <= 148) continue;
                x = 12;
                textLayout.newLine();
            }
            textLayout.newLine();
            textLayout.newLine();
            textLayout.newLine();
            textLayout.newLine();
            textLayout.drawLine(transform, Translator.translateToLocal("for.gui.beealyzer.specialty") + ":", 12);
            textLayout.newLine();
            x = 12;
            for (ItemStack stack : bee.getSpecialtyList()) {
                widgetManager.add(new ItemStackWidget(widgetManager, x, textLayout.getLineY(), stack));
                if ((x += 18) <= 148) continue;
                x = 12;
                textLayout.newLine();
            }
            textLayout.endPage();
        }
    }

    @Override
    public Map<ResourceLocation, ItemStack> getIconStacks() {
        return this.iconStacks;
    }

    @Override
    public List<String> getHints() {
        return Config.hints.get((Object)"beealyzer");
    }
}

