/*
 * Decompiled with CFR 0.152.
 */
package forestry.apiculture.genetics;

import forestry.api.apiculture.BeeManager;
import forestry.api.apiculture.genetics.BeeChromosomes;
import forestry.api.apiculture.genetics.EnumBeeType;
import forestry.api.apiculture.genetics.IAlleleBeeSpecies;
import forestry.api.apiculture.genetics.IBee;
import forestry.api.genetics.alleles.AlleleManager;
import forestry.api.genetics.gatgets.DatabaseMode;
import forestry.api.genetics.gatgets.IDatabaseTab;
import forestry.api.lepidopterology.genetics.ButterflyChromosomes;
import forestry.apiculture.genetics.BeeDefinition;
import forestry.core.gui.elements.Alignment;
import forestry.core.gui.elements.DatabaseElement;
import forestry.core.gui.elements.GuiElementFactory;
import forestry.core.utils.StringUtil;
import forestry.core.utils.Translator;
import genetics.api.organism.IOrganismType;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class BeeDatabaseTab
implements IDatabaseTab<IBee> {
    private final DatabaseMode mode;

    BeeDatabaseTab(DatabaseMode mode) {
        this.mode = mode;
    }

    @Override
    public DatabaseMode getMode() {
        return this.mode;
    }

    @Override
    public void createElements(DatabaseElement container, IBee bee, ItemStack itemStack) {
        String nocturnal;
        String diurnal;
        Optional<IOrganismType> optionalType = BeeManager.beeRoot.getTypes().getType(itemStack);
        if (!optionalType.isPresent()) {
            return;
        }
        IOrganismType type = optionalType.get();
        IAlleleBeeSpecies primarySpecies = bee.getGenome().getActiveAllele(BeeChromosomes.SPECIES);
        IAlleleBeeSpecies secondarySpecies = bee.getGenome().getInactiveAllele(BeeChromosomes.SPECIES);
        container.label(Translator.translateToLocal("for.gui.database.tab." + (this.mode == DatabaseMode.ACTIVE ? "active" : "inactive") + "_species"), Alignment.TOP_CENTER, GuiElementFactory.INSTANCE.databaseTitle);
        container.addLine(Translator.translateToLocal("for.gui.species"), BeeChromosomes.SPECIES);
        Function<Boolean, String> toleranceText = a -> {
            IAlleleBeeSpecies species = a != false ? primarySpecies : secondarySpecies;
            return AlleleManager.climateHelper.toDisplay(species.getTemperature()).getString();
        };
        container.addLine(Translator.translateToLocal("for.gui.climate"), toleranceText, BeeChromosomes.TEMPERATURE_TOLERANCE);
        container.addToleranceLine(BeeChromosomes.TEMPERATURE_TOLERANCE);
        container.addLine(Translator.translateToLocal("for.gui.humidity"), toleranceText, BeeChromosomes.HUMIDITY_TOLERANCE);
        container.addToleranceLine(BeeChromosomes.HUMIDITY_TOLERANCE);
        container.addLine(Translator.translateToLocal("for.gui.lifespan"), BeeChromosomes.LIFESPAN);
        container.addLine(Translator.translateToLocal("for.gui.speed"), BeeChromosomes.SPEED);
        container.addLine(Translator.translateToLocal("for.gui.pollination"), BeeChromosomes.FLOWERING);
        container.addLine(Translator.translateToLocal("for.gui.flowers"), BeeChromosomes.FLOWER_PROVIDER);
        container.addFertilityLine(Translator.translateToLocal("for.gui.fertility"), BeeChromosomes.FERTILITY, 0);
        container.addLine(Translator.translateToLocal("for.gui.area"), BeeChromosomes.TERRITORY);
        container.addLine(Translator.translateToLocal("for.gui.effect"), BeeChromosomes.EFFECT);
        String yes = Translator.translateToLocal("for.yes");
        String no = Translator.translateToLocal("for.no");
        if (this.mode == DatabaseMode.ACTIVE) {
            if (bee.getGenome().getActiveValue(BeeChromosomes.NEVER_SLEEPS).booleanValue()) {
                nocturnal = diurnal = yes;
            } else {
                nocturnal = primarySpecies.isNocturnal() ? yes : no;
                diurnal = !primarySpecies.isNocturnal() ? yes : no;
            }
        } else if (bee.getGenome().getInactiveValue(ButterflyChromosomes.NOCTURNAL).booleanValue()) {
            nocturnal = diurnal = yes;
        } else {
            nocturnal = secondarySpecies.isNocturnal() ? yes : no;
            diurnal = !secondarySpecies.isNocturnal() ? yes : no;
        }
        container.addLine(Translator.translateToLocal("for.gui.diurnal"), diurnal, false);
        container.addLine(Translator.translateToLocal("for.gui.nocturnal"), nocturnal, false);
        Function<Boolean, String> flyer = active -> StringUtil.readableBoolean(active != false ? bee.getGenome().getActiveValue(BeeChromosomes.TOLERATES_RAIN).booleanValue() : bee.getGenome().getInactiveValue(BeeChromosomes.TOLERATES_RAIN).booleanValue(), yes, no);
        container.addLine(Translator.translateToLocal("for.gui.flyer"), flyer, BeeChromosomes.TOLERATES_RAIN);
        Function<Boolean, String> cave = active -> StringUtil.readableBoolean(active != false ? bee.getGenome().getActiveValue(BeeChromosomes.CAVE_DWELLING).booleanValue() : bee.getGenome().getInactiveValue(BeeChromosomes.CAVE_DWELLING).booleanValue(), yes, no);
        container.addLine(Translator.translateToLocal("for.gui.cave"), cave, BeeChromosomes.CAVE_DWELLING);
        if (type == EnumBeeType.PRINCESS || type == EnumBeeType.QUEEN) {
            String displayTextKey = "for.bees.stock.pristine";
            if (!bee.isNatural()) {
                displayTextKey = "for.bees.stock.ignoble";
            }
            String displayText = Translator.translateToLocal(displayTextKey);
            container.label(displayText, Alignment.TOP_CENTER, GuiElementFactory.INSTANCE.binomial);
        }
    }

    @Override
    public ItemStack getIconStack() {
        return BeeDefinition.MEADOWS.getMemberStack(this.mode == DatabaseMode.ACTIVE ? EnumBeeType.PRINCESS : EnumBeeType.DRONE);
    }
}

