/*
 * Decompiled with CFR 0.152.
 */
package forestry.apiculture.genetics;

import com.mojang.blaze3d.matrix.MatrixStack;
import forestry.api.apiculture.genetics.BeeChromosomes;
import forestry.api.apiculture.genetics.IAlleleBeeSpecies;
import forestry.api.apiculture.genetics.IBee;
import forestry.api.core.tooltips.TextCollection;
import forestry.api.core.tooltips.TextCompound;
import forestry.api.core.tooltips.ToolTip;
import forestry.api.genetics.alleles.AlleleManager;
import forestry.api.genetics.alleles.IAlleleFlowers;
import forestry.api.genetics.alleles.IAlleleForestrySpecies;
import forestry.api.genetics.alyzer.IAlleleDisplayHandler;
import forestry.api.genetics.alyzer.IAlleleDisplayHelper;
import forestry.api.genetics.alyzer.IAlyzerHelper;
import forestry.core.genetics.GenericRatings;
import forestry.core.utils.GeneticsUtil;
import forestry.core.utils.Translator;
import genetics.api.alleles.IAllele;
import genetics.api.alleles.IAlleleValue;
import genetics.api.individual.IChromosomeAllele;
import genetics.api.individual.IChromosomeType;
import genetics.api.individual.IChromosomeValue;
import genetics.api.individual.IGenome;
import genetics.api.organism.IOrganismType;
import javax.annotation.Nullable;
import net.minecraft.item.Rarity;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;

public enum BeeDisplayHandler implements IAlleleDisplayHandler<IBee>
{
    GENERATIONS(-1){

        @Override
        public void addTooltip(ToolTip toolTip, IGenome genome, IBee individual) {
            int generation = individual.getGeneration();
            if (generation > 0) {
                Rarity rarity = generation >= 1000 ? Rarity.EPIC : (generation >= 100 ? Rarity.RARE : (generation >= 10 ? Rarity.UNCOMMON : Rarity.COMMON));
                ((TextCollection)toolTip.translated("for.gui.beealyzer.generations", generation)).style(rarity.field_77937_e);
            }
        }
    }
    ,
    SPECIES(BeeChromosomes.SPECIES, 0){

        @Override
        public void drawAlyzer(IAlyzerHelper helper, IGenome genome, double mouseX, double mouseY, MatrixStack transform) {
            IOrganismType organismType = helper.getOrganismType();
            ITextComponent primaryName = GeneticsUtil.getAlyzerName(organismType, (IAlleleForestrySpecies)this.getActiveAllele(genome));
            ITextComponent secondaryName = GeneticsUtil.getAlyzerName(organismType, (IAlleleForestrySpecies)this.getActiveAllele(genome));
            helper.drawSpeciesRow(Translator.translateToLocal("for.gui.species"), BeeChromosomes.SPECIES, primaryName, secondaryName);
        }
    }
    ,
    SPEED(BeeChromosomes.SPEED, 2, 1){

        @Override
        public void addTooltip(ToolTip toolTip, IGenome genome, IBee individual) {
            IAlleleValue speedAllele = this.getActive(genome);
            TranslationTextComponent customSpeed = new TranslationTextComponent("for.tooltip.worker." + speedAllele.getLocalisationKey().replaceAll("(.*)\\.", ""));
            if (Translator.canTranslate(customSpeed)) {
                ((TextCompound)toolTip.singleLine().add((ITextComponent)customSpeed).style(TextFormatting.GRAY)).create();
            } else {
                ((TextCompound)((TextCompound)((TextCompound)toolTip.singleLine().add(speedAllele.getDisplayName()).text(" ")).translated("for.gui.worker", new Object[0])).style(TextFormatting.GRAY)).create();
            }
        }
    }
    ,
    LIFESPAN(BeeChromosomes.LIFESPAN, 1, 0){

        @Override
        public void addTooltip(ToolTip toolTip, IGenome genome, IBee individual) {
            ((TextCompound)((TextCompound)((TextCompound)toolTip.singleLine().add(genome.getActiveAllele(BeeChromosomes.LIFESPAN).getDisplayName()).text(" ")).translated("for.gui.life", new Object[0])).style(TextFormatting.GRAY)).create();
        }
    }
    ,
    FERTILITY(BeeChromosomes.FERTILITY, 5, "fertility"){

        @Override
        public void drawAlyzer(IAlyzerHelper helper, IGenome genome, double mouseX, double mouseY, MatrixStack transform) {
            super.drawAlyzer(helper, genome, mouseX, mouseY, transform);
            IAlleleValue primaryFertility = (IAlleleValue)this.getActiveValue(genome);
            IAlleleValue secondaryFertility = (IAlleleValue)this.getInactiveValue(genome);
            helper.nextColumn();
            helper.drawFertilityInfo(primaryFertility);
            helper.nextColumn();
            helper.drawFertilityInfo(secondaryFertility);
        }
    }
    ,
    TEMPERATURE_TOLERANCE(BeeChromosomes.TEMPERATURE_TOLERANCE, -1, 2){

        @Override
        public void addTooltip(ToolTip toolTip, IGenome genome, IBee individual) {
            IAlleleBeeSpecies primary = genome.getActiveAllele(BeeChromosomes.SPECIES);
            IAlleleValue tempToleranceAllele = this.getActive(genome);
            ITextComponent caption = AlleleManager.climateHelper.toDisplay(primary.getTemperature());
            ((TextCompound)((TextCompound)((TextCompound)toolTip.singleLine().text("T: ")).add(caption).text(" / ")).add(tempToleranceAllele.getDisplayName()).style(TextFormatting.GREEN)).create();
        }
    }
    ,
    HUMIDITY_TOLERANCE(BeeChromosomes.HUMIDITY_TOLERANCE, -1, 3){

        @Override
        public void addTooltip(ToolTip toolTip, IGenome genome, IBee individual) {
            IAlleleBeeSpecies primary = genome.getActiveAllele(BeeChromosomes.SPECIES);
            IAlleleValue humidToleranceAllele = this.getActive(genome);
            ITextComponent caption = AlleleManager.climateHelper.toDisplay(primary.getHumidity());
            ((TextCompound)((TextCompound)((TextCompound)toolTip.singleLine().text("H: ")).add(caption).text(" / ")).add(humidToleranceAllele.getDisplayName()).style(TextFormatting.GREEN)).create();
        }
    }
    ,
    FLOWER_PROVIDER(BeeChromosomes.FLOWER_PROVIDER, 4, 4, "flowers"){

        @Override
        public void addTooltip(ToolTip toolTip, IGenome genome, IBee individual) {
            IAlleleFlowers flowers = (IAlleleFlowers)this.getActiveAllele(genome);
            toolTip.add(flowers.getProvider().getDescription(), TextFormatting.GRAY);
        }
    }
    ,
    FLOWERING(BeeChromosomes.FLOWERING, 3, -1, "pollination"),
    NEVER_SLEEPS(BeeChromosomes.NEVER_SLEEPS, -1, 5){

        @Override
        public void addTooltip(ToolTip toolTip, IGenome genome, IBee individual) {
            if (((Boolean)this.getActiveValue(genome)).booleanValue()) {
                ((TextCollection)toolTip.text(GenericRatings.rateActivityTime(true, false))).style(TextFormatting.RED);
            }
        }
    }
    ,
    TOLERATES_RAIN(BeeChromosomes.TOLERATES_RAIN, -1, 6){

        @Override
        public void addTooltip(ToolTip toolTip, IGenome genome, IBee individual) {
            if (((Boolean)this.getActiveValue(genome)).booleanValue()) {
                ((TextCollection)toolTip.translated("for.gui.flyer.tooltip", new Object[0])).style(TextFormatting.WHITE);
            }
        }
    }
    ,
    TERRITORY(BeeChromosomes.TERRITORY, 6, "area"),
    EFFECT(BeeChromosomes.EFFECT, 7, "effect");

    final IChromosomeType type;
    @Nullable
    final String alyzerCaption;
    final int alyzerIndex;
    final int tooltipIndex;

    private BeeDisplayHandler(IChromosomeType type, int alyzerIndex) {
        this(type, alyzerIndex, -1, (String)null);
    }

    private BeeDisplayHandler(IChromosomeType type, int alyzerIndex, int tooltipIndex) {
        this(type, alyzerIndex, tooltipIndex, (String)null);
    }

    private BeeDisplayHandler(@Nullable IChromosomeType type, int alyzerIndex, String alyzerCaption) {
        this(type, alyzerIndex, -1, alyzerCaption);
    }

    private BeeDisplayHandler(int tooltipIndex) {
        this.type = null;
        this.alyzerCaption = "";
        this.alyzerIndex = -1;
        this.tooltipIndex = tooltipIndex;
    }

    private BeeDisplayHandler(IChromosomeType type, @Nullable int alyzerIndex, int tooltipIndex, String alyzerCaption) {
        this.type = type;
        this.alyzerCaption = alyzerCaption;
        this.alyzerIndex = alyzerIndex;
        this.tooltipIndex = tooltipIndex;
    }

    public static void init(IAlleleDisplayHelper helper) {
        for (BeeDisplayHandler handler : BeeDisplayHandler.values()) {
            int alyzerIndex;
            int tooltipIndex = handler.tooltipIndex;
            if (tooltipIndex >= 0) {
                helper.addTooltip(handler, "rootBees", tooltipIndex * 10);
            }
            if ((alyzerIndex = handler.alyzerIndex) < 0) continue;
            helper.addAlyzer(handler, "rootBees", alyzerIndex * 10);
        }
    }

    @Override
    public void addTooltip(ToolTip toolTip, IGenome genome, IBee individual) {
    }

    @Override
    public void drawAlyzer(IAlyzerHelper helper, IGenome genome, double mouseX, double mouseY, MatrixStack transform) {
        if (this.alyzerCaption != null) {
            helper.drawChromosomeRow("for.gui." + this.alyzerCaption, this.type, true);
        }
    }

    <V> IAlleleValue<V> getActive(IGenome genome) {
        return genome.getActiveAllele((IChromosomeValue)this.type);
    }

    <V> IAlleleValue<V> getInactive(IGenome genome) {
        return genome.getInactiveAllele((IChromosomeValue)this.type);
    }

    <A extends IAllele> A getActiveAllele(IGenome genome) {
        return genome.getActiveAllele((IChromosomeAllele)this.type);
    }

    <A extends IAllele> A getInactiveAllele(IGenome genome) {
        return genome.getInactiveAllele((IChromosomeAllele)this.type);
    }

    <V> V getActiveValue(IGenome genome) {
        return genome.getActiveValue((IChromosomeValue)this.type);
    }

    <V> V getInactiveValue(IGenome genome) {
        return genome.getInactiveValue((IChromosomeValue)this.type);
    }
}

