/*
 * Decompiled with CFR 0.152.
 */
package forestry.apiculture.genetics;

import forestry.api.apiculture.genetics.BeeChromosomes;
import forestry.api.apiculture.genetics.EnumBeeType;
import forestry.api.apiculture.genetics.IAlleleBeeSpecies;
import forestry.api.apiculture.genetics.IBee;
import forestry.apiculture.genetics.BeeHelper;
import forestry.apiculture.genetics.IBeeDefinition;
import genetics.api.alleles.IAlleleTemplate;
import genetics.api.individual.IGenome;
import net.minecraft.item.ItemStack;

public abstract class BeeVariation
implements IBeeDefinition {
    private final IAlleleTemplate template;
    private final IGenome genome;

    protected BeeVariation(IBeeDefinition bee) {
        this.template = this.initializeTemplate(bee.getTemplate());
        this.genome = this.template.toGenome();
    }

    protected abstract IAlleleTemplate initializeTemplate(IAlleleTemplate var1);

    @Override
    public IAlleleTemplate getTemplate() {
        return this.template;
    }

    @Override
    public IGenome getGenome() {
        return this.genome;
    }

    @Override
    public IBee createIndividual() {
        return this.template.toIndividual(BeeHelper.getRoot());
    }

    @Override
    public final ItemStack getMemberStack(EnumBeeType beeType) {
        IBee bee = this.createIndividual();
        return BeeHelper.getRoot().getTypes().createStack(bee, beeType);
    }

    @Override
    public IAlleleBeeSpecies getSpecies() {
        return this.genome.getActiveAllele(BeeChromosomes.SPECIES);
    }

    public static class RainResist
    extends BeeVariation {
        public RainResist(IBeeDefinition bee) {
            super(bee);
        }

        @Override
        protected IAlleleTemplate initializeTemplate(IAlleleTemplate template) {
            return template.createBuilder().set(BeeChromosomes.TOLERATES_RAIN, true).build();
        }
    }
}

