/*
 * Decompiled with CFR 0.152.
 */
package forestry.apiculture.genetics;

import forestry.api.apiculture.genetics.IBee;
import forestry.api.apiculture.hives.IHiveDrop;
import forestry.apiculture.genetics.IBeeDefinition;
import java.util.Collections;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;

public class HiveDrop
implements IHiveDrop {
    private final IBeeDefinition beeTemplate;
    private final NonNullList<ItemStack> additional = NonNullList.func_191196_a();
    private final double chance;
    private double ignobleShare = 0.0;

    public HiveDrop(double chance, IBeeDefinition beeTemplate, ItemStack ... bonus) {
        this.beeTemplate = beeTemplate;
        this.chance = chance;
        Collections.addAll(this.additional, bonus);
    }

    public HiveDrop setIgnobleShare(double share) {
        this.ignobleShare = share;
        return this;
    }

    @Override
    public IBee getBeeType(IBlockReader world, BlockPos pos) {
        return (IBee)this.beeTemplate.createIndividual();
    }

    @Override
    public NonNullList<ItemStack> getExtraItems(IBlockReader world, BlockPos pos, int fortune) {
        NonNullList ret = NonNullList.func_191196_a();
        for (ItemStack stack : this.additional) {
            ret.add((Object)stack.func_77946_l());
        }
        return ret;
    }

    @Override
    public double getChance(IBlockReader world, BlockPos pos, int fortune) {
        return this.chance;
    }

    @Override
    public double getIgnobleChance(IBlockReader world, BlockPos pos, int fortune) {
        return this.ignobleShare;
    }
}

