/*
 * Decompiled with CFR 0.152.
 */
package forestry.apiculture.genetics.alleles;

import com.google.common.base.Preconditions;
import forestry.api.apiculture.BeeManager;
import forestry.api.apiculture.IBeeHousing;
import forestry.api.apiculture.IBeeSpriteColourProvider;
import forestry.api.apiculture.IJubilanceProvider;
import forestry.api.apiculture.genetics.IAlleleBeeSpecies;
import forestry.api.apiculture.genetics.IAlleleBeeSpeciesBuilder;
import forestry.api.apiculture.genetics.IBeeRoot;
import forestry.api.core.ISetupListener;
import forestry.api.genetics.products.IDynamicProductList;
import forestry.apiculture.genetics.DefaultBeeSpriteColourProvider;
import forestry.apiculture.genetics.JubilanceDefault;
import forestry.core.genetics.ProductListWrapper;
import forestry.core.genetics.alleles.AlleleForestrySpecies;
import genetics.api.individual.IGenome;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;

public class AlleleBeeSpecies
extends AlleleForestrySpecies
implements IAlleleBeeSpecies,
ISetupListener {
    private final IBeeSpriteColourProvider beeSpriteColourProvider;
    private final IJubilanceProvider jubilanceProvider;
    private final boolean nocturnal;
    private ProductListWrapper products;
    private ProductListWrapper specialties;

    public AlleleBeeSpecies(Builder builder) {
        super(builder);
        this.beeSpriteColourProvider = builder.beeSpriteColourProvider;
        this.jubilanceProvider = builder.jubilanceProvider;
        this.products = builder.products;
        this.specialties = builder.specialties;
        this.nocturnal = builder.nocturnal;
    }

    @Override
    public void onFinishSetup() {
        this.products = this.products.bake();
        this.specialties = this.specialties.bake();
    }

    @Override
    public IBeeRoot getRoot() {
        return BeeManager.beeRoot;
    }

    @Override
    public boolean isNocturnal() {
        return this.nocturnal;
    }

    @Override
    public IDynamicProductList getProducts() {
        return this.products;
    }

    @Override
    public IDynamicProductList getSpecialties() {
        return this.specialties;
    }

    @Override
    public boolean isJubilant(IGenome genome, IBeeHousing housing) {
        return this.jubilanceProvider.isJubilant(this, genome, housing);
    }

    @Override
    public int getSpriteColour(int renderPass) {
        return this.beeSpriteColourProvider.getSpriteColour(renderPass);
    }

    public static class Builder
    extends AlleleForestrySpecies.AbstractBuilder<IAlleleBeeSpeciesBuilder>
    implements IAlleleBeeSpeciesBuilder {
        private final ProductListWrapper products = ProductListWrapper.create();
        private final ProductListWrapper specialties = ProductListWrapper.create();
        @Nullable
        private IBeeSpriteColourProvider beeSpriteColourProvider;
        private IJubilanceProvider jubilanceProvider = JubilanceDefault.instance;
        private boolean nocturnal = false;

        public Builder(String modId, String uid, String speciesIdentifier) {
            super(modId, uid, speciesIdentifier);
        }

        protected static void checkBuilder(Builder builder) {
            AlleleForestrySpecies.AbstractBuilder.checkBuilder(builder);
            Preconditions.checkNotNull((Object)builder.beeSpriteColourProvider);
        }

        @Override
        public IAlleleBeeSpeciesBuilder cast() {
            return this;
        }

        @Override
        public IAlleleBeeSpecies build() {
            Builder.checkBuilder(this);
            return new AlleleBeeSpecies(this);
        }

        @Override
        public IAlleleBeeSpeciesBuilder setColour(IBeeSpriteColourProvider colourProvider) {
            this.beeSpriteColourProvider = colourProvider;
            return this;
        }

        @Override
        public IAlleleBeeSpeciesBuilder setColour(int primaryColor, int secondaryColor) {
            this.beeSpriteColourProvider = new DefaultBeeSpriteColourProvider(primaryColor, secondaryColor);
            return this;
        }

        @Override
        public IAlleleBeeSpeciesBuilder addProduct(Supplier<ItemStack> product, Float chance) {
            this.products.addProduct(product, chance.floatValue());
            return this;
        }

        @Override
        public IAlleleBeeSpeciesBuilder addSpecialty(Supplier<ItemStack> specialty, Float chance) {
            this.specialties.addProduct(specialty, chance.floatValue());
            return this;
        }

        @Override
        public IAlleleBeeSpeciesBuilder setJubilanceProvider(IJubilanceProvider provider) {
            this.jubilanceProvider = provider;
            return this;
        }

        @Override
        public IAlleleBeeSpeciesBuilder setNocturnal() {
            this.nocturnal = true;
            return this;
        }

        @Override
        public IAlleleBeeSpeciesBuilder setCustomBeeSpriteColourProvider(IBeeSpriteColourProvider beeIconColourProvider) {
            this.beeSpriteColourProvider = beeIconColourProvider;
            return this;
        }
    }
}

