/*
 * Decompiled with CFR 0.152.
 */
package forestry.apiculture.genetics.alleles;

import forestry.api.apiculture.BeeManager;
import forestry.api.apiculture.IBeeHousing;
import forestry.api.apiculture.IBeeModifier;
import forestry.api.apiculture.IBeekeepingLogic;
import forestry.api.apiculture.genetics.BeeChromosomes;
import forestry.api.apiculture.genetics.IAlleleBeeEffect;
import forestry.api.genetics.IEffectData;
import forestry.core.render.ParticleRender;
import forestry.core.utils.VectUtil;
import genetics.api.alleles.AlleleCategorized;
import genetics.api.individual.IGenome;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public abstract class AlleleEffect
extends AlleleCategorized
implements IAlleleBeeEffect {
    protected AlleleEffect(String valueName, boolean isDominant) {
        super("forestry", "effect", valueName, isDominant);
    }

    @Override
    public IEffectData validateStorage(IEffectData storedData) {
        return storedData;
    }

    @Override
    public boolean isCombinable() {
        return false;
    }

    @Override
    public IEffectData doEffect(IGenome genome, IEffectData storedData, IBeeHousing housing) {
        return storedData;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public IEffectData doFX(IGenome genome, IEffectData storedData, IBeeHousing housing) {
        IBeekeepingLogic beekeepingLogic = housing.getBeekeepingLogic();
        List<BlockPos> flowerPositions = beekeepingLogic.getFlowerPositions();
        ParticleRender.addBeeHiveFX(housing, genome, flowerPositions);
        return storedData;
    }

    public static Vector3i getModifiedArea(IGenome genome, IBeeHousing housing) {
        IBeeModifier beeModifier = BeeManager.beeRoot.createBeeHousingModifier(housing);
        float territoryModifier = beeModifier.getTerritoryModifier(genome, 1.0f);
        BlockPos area = VectUtil.scale(genome.getActiveValue(BeeChromosomes.TERRITORY), territoryModifier);
        int x = area.func_177958_n();
        int y = area.func_177956_o();
        int z = area.func_177952_p();
        if (x < 1) {
            x = 1;
        }
        if (y < 1) {
            y = 1;
        }
        if (z < 1) {
            z = 1;
        }
        return new Vector3i(x, y, z);
    }

    public static AxisAlignedBB getBounding(IGenome genome, IBeeHousing housing) {
        IBeeModifier beeModifier = BeeManager.beeRoot.createBeeHousingModifier(housing);
        float territoryModifier = beeModifier.getTerritoryModifier(genome, 1.0f);
        BlockPos area = VectUtil.scale(genome.getActiveValue(BeeChromosomes.TERRITORY), territoryModifier);
        BlockPos offset = VectUtil.scale((Vector3i)area, -0.5f);
        BlockPos min = housing.getCoordinates().func_177971_a((Vector3i)offset);
        BlockPos max = min.func_177971_a((Vector3i)area);
        return new AxisAlignedBB((double)min.func_177958_n(), (double)min.func_177956_o(), (double)min.func_177952_p(), (double)max.func_177958_n(), (double)max.func_177956_o(), (double)max.func_177952_p());
    }

    public static <T extends Entity> List<T> getEntitiesInRange(IGenome genome, IBeeHousing housing, Class<T> entityClass) {
        AxisAlignedBB boundingBox = AlleleEffect.getBounding(genome, housing);
        return housing.getWorldObj().func_217357_a(entityClass, boundingBox);
    }
}

