/*
 * Decompiled with CFR 0.152.
 */
package forestry.apiculture.genetics.alleles;

import forestry.api.apiculture.IBeeHousing;
import forestry.api.apiculture.genetics.BeeChromosomes;
import forestry.api.core.EnumTemperature;
import forestry.api.genetics.IEffectData;
import forestry.apiculture.genetics.alleles.AlleleEffectThrottled;
import forestry.core.utils.VectUtil;
import genetics.api.individual.IGenome;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.World;

public class AlleleEffectGlacial
extends AlleleEffectThrottled {
    public AlleleEffectGlacial() {
        super("glacial", false, 200, true, false);
    }

    @Override
    public IEffectData doEffectThrottled(IGenome genome, IEffectData storedData, IBeeHousing housing) {
        World world = housing.getWorldObj();
        EnumTemperature temp = housing.getTemperature();
        switch (temp) {
            case HELLISH: 
            case HOT: 
            case WARM: {
                return storedData;
            }
        }
        Vector3i area = genome.getActiveValue(BeeChromosomes.TERRITORY);
        BlockPos offset = VectUtil.scale(area, -0.5f);
        BlockPos housingCoords = housing.getCoordinates();
        for (int i = 0; i < 10; ++i) {
            Block block;
            BlockPos randomPos = VectUtil.getRandomPositionInArea(world.field_73012_v, area);
            BlockPos posBlock = VectUtil.add(new Vector3i[]{randomPos, housingCoords, offset});
            if (!world.func_175667_e(posBlock) || (block = world.func_180495_p(posBlock).func_177230_c()) != Blocks.field_150355_j || !world.func_175623_d(new BlockPos(posBlock.func_177958_n(), posBlock.func_177956_o() + 1, posBlock.func_177952_p()))) continue;
            world.func_175656_a(posBlock, Blocks.field_150432_aD.func_176223_P());
        }
        return storedData;
    }
}

