/*
 * Decompiled with CFR 0.152.
 */
package forestry.apiculture.genetics.alleles;

import forestry.api.apiculture.BeeManager;
import forestry.api.apiculture.IBeeHousing;
import forestry.api.genetics.IEffectData;
import forestry.apiculture.genetics.alleles.AlleleEffectThrottled;
import forestry.core.render.ParticleRender;
import forestry.core.utils.WorldUtils;
import genetics.api.individual.IGenome;
import java.util.List;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.entity.LivingEntity;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class AlleleEffectIgnition
extends AlleleEffectThrottled {
    private static final int ignitionChance = 50;
    private static final int fireDuration = 500;

    public AlleleEffectIgnition() {
        super("ignition", false, 20, false, true);
    }

    @Override
    public IEffectData doEffectThrottled(IGenome genome, IEffectData storedData, IBeeHousing housing) {
        World world = housing.getWorldObj();
        List<LivingEntity> entities = AlleleEffectIgnition.getEntitiesInRange(genome, housing, LivingEntity.class);
        for (LivingEntity entity : entities) {
            int chance = 50;
            int duration = 500;
            int count = BeeManager.armorApiaristHelper.wearsItems(entity, this.getRegistryName(), true);
            if (count > 3) continue;
            if (count > 2) {
                chance = 5;
                duration = 50;
            } else if (count > 1) {
                chance = 20;
                duration = 200;
            } else if (count > 0) {
                chance = 35;
                duration = 350;
            }
            if (world.field_73012_v.nextInt(1000) >= chance) continue;
            entity.func_70015_d(duration);
        }
        return storedData;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public IEffectData doFX(IGenome genome, IEffectData storedData, IBeeHousing housing) {
        ClientWorld world = WorldUtils.asClient((IWorld)housing.getWorldObj());
        if (world.field_73012_v.nextInt(2) != 0) {
            super.doFX(genome, storedData, housing);
        } else {
            Vector3d beeFXCoordinates = housing.getBeeFXCoordinates();
            ParticleRender.addEntityIgnitionFX(world, beeFXCoordinates.field_72450_a, beeFXCoordinates.field_72448_b + 0.5, beeFXCoordinates.field_72449_c);
        }
        return storedData;
    }
}

