/*
 * Decompiled with CFR 0.152.
 */
package forestry.apiculture.genetics.alleles;

import forestry.api.apiculture.IBeeHousing;
import forestry.api.core.EnumTemperature;
import forestry.api.genetics.IEffectData;
import forestry.apiculture.genetics.alleles.AlleleEffectThrottled;
import forestry.core.render.ParticleRender;
import forestry.core.utils.VectUtil;
import genetics.api.individual.IGenome;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.SnowBlock;
import net.minecraft.state.Property;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class AlleleEffectSnowing
extends AlleleEffectThrottled {
    public AlleleEffectSnowing() {
        super("snowing", false, 20, true, true);
    }

    @Override
    public IEffectData doEffectThrottled(IGenome genome, IEffectData storedData, IBeeHousing housing) {
        World world = housing.getWorldObj();
        EnumTemperature temp = housing.getTemperature();
        switch (temp) {
            case HELLISH: 
            case HOT: 
            case WARM: {
                return storedData;
            }
        }
        Vector3i area = AlleleEffectSnowing.getModifiedArea(genome, housing);
        BlockPos offset = VectUtil.scale(area, -0.5f);
        for (int i = 0; i < 1; ++i) {
            BlockPos randomPos = VectUtil.getRandomPositionInArea(world.field_73012_v, area);
            BlockPos posBlock = randomPos.func_177971_a((Vector3i)housing.getCoordinates()).func_177971_a((Vector3i)offset);
            if (!world.func_175667_e(posBlock)) continue;
            BlockState state = world.func_180495_p(posBlock);
            Block block = state.func_177230_c();
            if (!state.isAir((IBlockReader)world, posBlock) && block != Blocks.field_150433_aE || !Blocks.field_150433_aE.func_176223_P().func_196955_c((IWorldReader)world, posBlock)) continue;
            if (block == Blocks.field_150433_aE) {
                int layers = (Integer)state.func_177229_b((Property)SnowBlock.field_176315_a);
                if (layers < 7) {
                    BlockState moreSnow = (BlockState)state.func_206870_a((Property)SnowBlock.field_176315_a, (Comparable)Integer.valueOf(layers + 1));
                    world.func_175656_a(posBlock, moreSnow);
                    continue;
                }
                world.func_175656_a(posBlock, Blocks.field_150433_aE.func_176223_P());
                continue;
            }
            if (!block.func_176223_P().func_185904_a().func_76222_j()) continue;
            world.func_175656_a(posBlock, Blocks.field_150433_aE.func_176223_P());
        }
        return storedData;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public IEffectData doFX(IGenome genome, IEffectData storedData, IBeeHousing housing) {
        if (housing.getWorldObj().field_73012_v.nextInt(3) == 0) {
            Vector3i area = AlleleEffectSnowing.getModifiedArea(genome, housing);
            BlockPos offset = VectUtil.scale(area, -0.5f);
            BlockPos coordinates = housing.getCoordinates();
            World world = housing.getWorldObj();
            BlockPos spawn = VectUtil.getRandomPositionInArea(world.field_73012_v, area).func_177971_a((Vector3i)coordinates).func_177971_a((Vector3i)offset);
            ParticleRender.addEntitySnowFX(world, spawn.func_177958_n(), spawn.func_177956_o(), spawn.func_177952_p());
            return storedData;
        }
        return super.doFX(genome, storedData, housing);
    }
}

