/*
 * Decompiled with CFR 0.152.
 */
package forestry.apiculture.genetics.alleles;

import forestry.api.apiculture.genetics.BeeChromosomes;
import forestry.api.apiculture.genetics.IAlleleBeeEffect;
import forestry.apiculture.genetics.alleles.AlleleEffectAggressive;
import forestry.apiculture.genetics.alleles.AlleleEffectCreeper;
import forestry.apiculture.genetics.alleles.AlleleEffectExploration;
import forestry.apiculture.genetics.alleles.AlleleEffectFertile;
import forestry.apiculture.genetics.alleles.AlleleEffectFungification;
import forestry.apiculture.genetics.alleles.AlleleEffectGlacial;
import forestry.apiculture.genetics.alleles.AlleleEffectHeroic;
import forestry.apiculture.genetics.alleles.AlleleEffectIgnition;
import forestry.apiculture.genetics.alleles.AlleleEffectMisanthrope;
import forestry.apiculture.genetics.alleles.AlleleEffectNone;
import forestry.apiculture.genetics.alleles.AlleleEffectPotion;
import forestry.apiculture.genetics.alleles.AlleleEffectRadioactive;
import forestry.apiculture.genetics.alleles.AlleleEffectRepulsion;
import forestry.apiculture.genetics.alleles.AlleleEffectResurrection;
import forestry.apiculture.genetics.alleles.AlleleEffectSnowing;
import genetics.api.alleles.IAlleleRegistry;
import java.util.Arrays;
import java.util.List;
import net.minecraft.potion.Effects;

public class AlleleEffects {
    public static final IAlleleBeeEffect effectNone = new AlleleEffectNone("none", true);
    public static final IAlleleBeeEffect effectAggressive = new AlleleEffectAggressive();
    public static final IAlleleBeeEffect effectHeroic = new AlleleEffectHeroic();
    public static final IAlleleBeeEffect effectBeatific = new AlleleEffectPotion("beatific", false, Effects.field_76428_l, 100);
    public static final IAlleleBeeEffect effectMiasmic = new AlleleEffectPotion("miasmic", false, Effects.field_76436_u, 600, 100, 0.1f);
    public static final IAlleleBeeEffect effectMisanthrope = new AlleleEffectMisanthrope();
    public static final IAlleleBeeEffect effectGlacial = new AlleleEffectGlacial();
    public static final IAlleleBeeEffect effectRadioactive = new AlleleEffectRadioactive();
    public static final IAlleleBeeEffect effectCreeper = new AlleleEffectCreeper();
    public static final IAlleleBeeEffect effectIgnition = new AlleleEffectIgnition();
    public static final IAlleleBeeEffect effectExploration = new AlleleEffectExploration();
    public static final IAlleleBeeEffect effectFestiveEaster = new AlleleEffectNone("festive_easter", true);
    public static final IAlleleBeeEffect effectSnowing = new AlleleEffectSnowing();
    public static final IAlleleBeeEffect effectDrunkard = new AlleleEffectPotion("drunkard", false, Effects.field_76431_k, 100);
    public static final IAlleleBeeEffect effectReanimation = new AlleleEffectResurrection("reanimation", AlleleEffectResurrection.getReanimationList());
    public static final IAlleleBeeEffect effectResurrection;
    public static final IAlleleBeeEffect effectRepulsion;
    public static final IAlleleBeeEffect effectFertile;
    public static final IAlleleBeeEffect effectMycophilic;
    private static final List<IAlleleBeeEffect> beeEffects;

    public static void registerAlleles(IAlleleRegistry registry) {
        for (IAlleleBeeEffect beeEffect : beeEffects) {
            registry.registerAllele(beeEffect, BeeChromosomes.EFFECT);
        }
    }

    static {
        beeEffects = Arrays.asList(effectNone, effectAggressive, effectHeroic, effectBeatific, effectMiasmic, effectMisanthrope, effectGlacial, effectRadioactive, effectCreeper, effectIgnition, effectExploration, effectFestiveEaster, effectSnowing, effectDrunkard, effectReanimation, effectResurrection = new AlleleEffectResurrection("resurrection", AlleleEffectResurrection.getResurrectionList()), effectRepulsion = new AlleleEffectRepulsion(), effectFertile = new AlleleEffectFertile(), effectMycophilic = new AlleleEffectFungification());
    }
}

