/*
 * Decompiled with CFR 0.152.
 */
package forestry.apiculture.gui;

import forestry.api.climate.IClimateListener;
import forestry.apiculture.features.ApicultureContainers;
import forestry.apiculture.gui.ContainerBeeHelper;
import forestry.apiculture.gui.GuiBeeHousing;
import forestry.apiculture.gui.IContainerBeeHousing;
import forestry.apiculture.gui.IGuiBeeHousingDelegate;
import forestry.apiculture.tiles.TileBeeHousingBase;
import forestry.core.climate.ClimateRoot;
import forestry.core.gui.ContainerAnalyzerProvider;
import forestry.core.network.IStreamableGui;
import forestry.core.network.PacketBufferForestry;
import forestry.core.network.packets.PacketGuiUpdate;
import forestry.core.tiles.TileUtil;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.world.IBlockReader;
import net.minecraftforge.common.util.LazyOptional;

public class ContainerBeeHousing
extends ContainerAnalyzerProvider<TileBeeHousingBase>
implements IContainerBeeHousing {
    private final IGuiBeeHousingDelegate delegate;
    private final GuiBeeHousing.Icon icon;
    private int beeProgress = -1;

    public static ContainerBeeHousing fromNetwork(int windowId, PlayerInventory inv, PacketBuffer data) {
        PacketBufferForestry buf = new PacketBufferForestry((ByteBuf)data);
        TileBeeHousingBase tile = TileUtil.getTile((IBlockReader)inv.field_70458_d.field_70170_p, buf.func_179259_c(), TileBeeHousingBase.class);
        boolean hasFrames = buf.readBoolean();
        GuiBeeHousing.Icon icon = (GuiBeeHousing.Icon)buf.readEnum(GuiBeeHousing.Icon.values());
        return new ContainerBeeHousing(windowId, inv, tile, hasFrames, icon);
    }

    public ContainerBeeHousing(int windowId, PlayerInventory player, TileBeeHousingBase tile, boolean hasFrames, GuiBeeHousing.Icon icon) {
        super(windowId, ApicultureContainers.BEE_HOUSING.containerType(), player, tile, 8, 108);
        ContainerBeeHelper.addSlots(this, tile, hasFrames);
        tile.getBeekeepingLogic().clearCachedValues();
        LazyOptional<IClimateListener> listener = ClimateRoot.getInstance().getListener(tile.func_145831_w(), tile.func_174877_v());
        if (player.field_70458_d instanceof ServerPlayerEntity) {
            listener.ifPresent(l -> l.syncToClient((ServerPlayerEntity)player.field_70458_d));
        }
        this.delegate = tile;
        this.icon = icon;
    }

    @Override
    public void func_75142_b() {
        super.func_75142_b();
        int beeProgress = ((TileBeeHousingBase)this.tile).getBeekeepingLogic().getBeeProgressPercent();
        if (this.beeProgress != beeProgress) {
            this.beeProgress = beeProgress;
            PacketGuiUpdate packet = new PacketGuiUpdate((IStreamableGui)this.tile);
            this.sendPacketToListeners(packet);
        }
    }

    @Override
    public IGuiBeeHousingDelegate getDelegate() {
        return this.delegate;
    }

    @Override
    public GuiBeeHousing.Icon getIcon() {
        return this.icon;
    }
}

