/*
 * Decompiled with CFR 0.152.
 */
package forestry.apiculture.gui;

import forestry.apiculture.features.ApicultureContainers;
import forestry.apiculture.inventory.ItemInventoryImprinter;
import forestry.apiculture.network.packets.PacketImprintSelectionResponse;
import forestry.core.gui.ContainerItemInventory;
import forestry.core.gui.IGuiSelectable;
import forestry.core.gui.slots.SlotFiltered;
import forestry.core.gui.slots.SlotOutput;
import forestry.core.utils.NetworkUtil;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.Hand;

public class ContainerImprinter
extends ContainerItemInventory<ItemInventoryImprinter>
implements IGuiSelectable {
    public static ContainerImprinter fromNetwork(int windowId, PlayerInventory playerInv, PacketBuffer extraData) {
        Hand hand = extraData.readBoolean() ? Hand.MAIN_HAND : Hand.OFF_HAND;
        PlayerEntity player = playerInv.field_70458_d;
        ItemInventoryImprinter inv = new ItemInventoryImprinter(player, player.func_184586_b(hand));
        return new ContainerImprinter(windowId, player.field_71071_by, inv);
    }

    public ContainerImprinter(int windowId, PlayerInventory inventoryplayer, ItemInventoryImprinter inventory) {
        super(windowId, inventory, inventoryplayer, 8, 103, ApicultureContainers.IMPRINTER.containerType());
        this.func_75146_a(new SlotFiltered(inventory, 0, 152, 12));
        this.func_75146_a(new SlotOutput(inventory, 1, 152, 72));
    }

    @Override
    public void handleSelectionRequest(ServerPlayerEntity player, int primary, int secondary) {
        if (primary == 0) {
            if (secondary == 0) {
                ((ItemInventoryImprinter)this.inventory).advancePrimary();
            } else {
                ((ItemInventoryImprinter)this.inventory).regressPrimary();
            }
        } else if (secondary == 0) {
            ((ItemInventoryImprinter)this.inventory).advanceSecondary();
        } else {
            ((ItemInventoryImprinter)this.inventory).regressSecondary();
        }
        PacketImprintSelectionResponse packetResponse = new PacketImprintSelectionResponse(((ItemInventoryImprinter)this.inventory).getPrimaryIndex(), ((ItemInventoryImprinter)this.inventory).getSecondaryIndex());
        NetworkUtil.sendToPlayer(packetResponse, (PlayerEntity)player);
    }

    public void setSelection(int primary, int secondary) {
        ((ItemInventoryImprinter)this.inventory).setPrimaryIndex(primary);
        ((ItemInventoryImprinter)this.inventory).setSecondaryIndex(secondary);
    }
}

