/*
 * Decompiled with CFR 0.152.
 */
package forestry.apiculture.gui;

import com.google.common.collect.LinkedListMultimap;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import forestry.apiculture.gui.ContainerHabitatLocator;
import forestry.apiculture.gui.HabitatSlot;
import forestry.apiculture.inventory.ItemInventoryHabitatLocator;
import forestry.core.gui.GuiForestry;
import forestry.core.render.ColourProperties;
import forestry.core.utils.Translator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.registries.ForgeRegistries;

public class GuiHabitatLocator
extends GuiForestry<ContainerHabitatLocator> {
    private static final LinkedListMultimap<String, Biome.Category> habitats = LinkedListMultimap.create();
    private final ItemInventoryHabitatLocator itemInventory;
    private final List<HabitatSlot> habitatSlots = new ArrayList<HabitatSlot>(habitats.size());
    private int startX;
    private int startY;

    public GuiHabitatLocator(ContainerHabitatLocator container, PlayerInventory playerInv, ITextComponent title) {
        super("textures/gui/biomefinder.png", container, playerInv, title);
        this.itemInventory = (ItemInventoryHabitatLocator)container.getItemInventory();
        this.field_146999_f = 176;
        this.field_147000_g = 184;
        int slot = 0;
        for (String habitatName : habitats.keySet()) {
            int y;
            int x;
            if (slot > 5) {
                x = 18 + (slot - 6) * 20;
                y = 50;
            } else {
                x = 18 + slot * 20;
                y = 32;
            }
            List biomes = habitats.get((Object)habitatName);
            HabitatSlot habitatSlot = new HabitatSlot(this.widgetManager, x, y, habitatName, biomes);
            this.habitatSlots.add(habitatSlot);
            this.widgetManager.add(habitatSlot);
            ++slot;
        }
    }

    @Override
    protected void func_230450_a_(MatrixStack transform, float partialTicks, int mouseY, int mouseX) {
        String str = Translator.translateToLocal("item.forestry.habitat_locator").toUpperCase(Locale.ENGLISH);
        this.getFontRenderer().func_238421_b_(transform, str, (float)(this.startX + 8 + this.textLayout.getCenteredOffset(str, 138)), (float)(this.startY + 16), ColourProperties.INSTANCE.get("gui.screen"));
        HashSet<Biome.Category> activeBiomeTypes = new HashSet<Biome.Category>();
        for (ResourceLocation biomeLocation : this.itemInventory.getBiomesToSearch()) {
            Biome biome = (Biome)ForgeRegistries.BIOMES.getValue(biomeLocation);
            if (biome == null) continue;
            Biome.Category biomeTypes = biome.func_201856_r();
            activeBiomeTypes.add(biomeTypes);
        }
        for (HabitatSlot habitatSlot : this.habitatSlots) {
            habitatSlot.setActive(activeBiomeTypes);
        }
        for (HabitatSlot slot : this.habitatSlots) {
            slot.draw(transform, this.startY, this.startX);
        }
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    @Override
    public void func_231160_c_() {
        super.func_231160_c_();
        this.startX = (this.field_230708_k_ - this.field_146999_f) / 2;
        this.startY = (this.field_230709_l_ - this.field_147000_g) / 2;
    }

    @Override
    protected void addLedgers() {
        this.addErrorLedger(this.itemInventory);
        this.addHintLedger("habitat.locator");
    }

    static {
        habitats.putAll((Object)"Ocean", Arrays.asList(Biome.Category.OCEAN, Biome.Category.BEACH));
        habitats.put((Object)"Plains", (Object)Biome.Category.PLAINS);
        habitats.put((Object)"Desert", (Object)Biome.Category.DESERT);
        habitats.putAll((Object)"Forest", Arrays.asList(Biome.Category.FOREST, Biome.Category.RIVER));
        habitats.put((Object)"Jungle", (Object)Biome.Category.JUNGLE);
        habitats.put((Object)"Taiga", (Object)Biome.Category.TAIGA);
        habitats.put((Object)"Hills", (Object)Biome.Category.EXTREME_HILLS);
        habitats.put((Object)"Swamp", (Object)Biome.Category.SWAMP);
        habitats.put((Object)"Snow", (Object)Biome.Category.ICY);
        habitats.put((Object)"Mushroom", (Object)Biome.Category.MUSHROOM);
        habitats.put((Object)"Nether", (Object)Biome.Category.NETHER);
        habitats.put((Object)"End", (Object)Biome.Category.THEEND);
    }
}

