/*
 * Decompiled with CFR 0.152.
 */
package forestry.apiculture.gui;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import forestry.api.core.tooltips.ToolTip;
import forestry.core.gui.widgets.Widget;
import forestry.core.gui.widgets.WidgetManager;
import forestry.core.render.TextureManagerForestry;
import java.util.Collection;
import java.util.Collections;
import java.util.Locale;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class HabitatSlot
extends Widget {
    private final Collection<Biome.Category> biomes;
    private final String name;
    private final String iconIndex;
    public boolean isActive = false;

    public HabitatSlot(WidgetManager widgetManager, int xPos, int yPos, String name, Collection<Biome.Category> biomes) {
        super(widgetManager, xPos, yPos);
        this.biomes = biomes;
        this.name = name;
        this.iconIndex = "habitats/" + name.toLowerCase(Locale.ENGLISH);
    }

    @Override
    public ToolTip getToolTip(int mouseX, int mouseY) {
        ToolTip tooltip = new ToolTip();
        tooltip.add((ITextComponent)new StringTextComponent(this.name));
        return tooltip;
    }

    @OnlyIn(value=Dist.CLIENT)
    public TextureAtlasSprite getIcon() {
        return TextureManagerForestry.getInstance().getDefault(this.iconIndex);
    }

    public void setActive(Collection<Biome.Category> biomes) {
        this.isActive = !Collections.disjoint(this.biomes, biomes);
    }

    @Override
    public void draw(MatrixStack transform, int startY, int startX) {
        if (!this.isActive) {
            RenderSystem.color4f((float)0.2f, (float)0.2f, (float)0.2f, (float)0.2f);
        } else {
            RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
        TextureManagerForestry.getInstance().bindGuiTextureMap();
        AbstractGui.func_238470_a_((MatrixStack)transform, (int)(startX + this.xPos), (int)(startY + this.yPos), (int)this.manager.gui.func_230927_p_(), (int)16, (int)16, (TextureAtlasSprite)this.getIcon());
    }
}

