/*
 * Decompiled with CFR 0.152.
 */
package forestry.apiculture.items;

import forestry.api.apiculture.genetics.BeeChromosomes;
import forestry.api.apiculture.genetics.EnumBeeType;
import forestry.api.apiculture.genetics.IAlleleBeeSpecies;
import forestry.api.apiculture.genetics.IBee;
import forestry.api.apiculture.genetics.IBeeRoot;
import forestry.api.core.ItemGroups;
import forestry.apiculture.genetics.BeeHelper;
import forestry.core.config.Config;
import forestry.core.genetics.ItemGE;
import forestry.core.items.definitions.IColoredItem;
import genetics.api.GeneticHelper;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.ICapabilityProvider;

public class ItemBeeGE
extends ItemGE
implements IColoredItem {
    private final EnumBeeType type;

    public ItemBeeGE(EnumBeeType type) {
        super(type != EnumBeeType.DRONE ? new Item.Properties().func_200916_a(ItemGroups.tabApiculture).func_200918_c(1) : new Item.Properties().func_200916_a(ItemGroups.tabApiculture));
        this.type = type;
    }

    @Nullable
    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable CompoundNBT nbt) {
        return GeneticHelper.createOrganism(stack, this.type, BeeHelper.getRoot().getDefinition());
    }

    @Override
    protected IAlleleBeeSpecies getSpecies(ItemStack itemStack) {
        return GeneticHelper.getOrganism(itemStack).getAllele(BeeChromosomes.SPECIES, true);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack itemstack, @Nullable World world, List<ITextComponent> list, ITooltipFlag flag) {
        if (!itemstack.func_77942_o()) {
            return;
        }
        if (this.type != EnumBeeType.DRONE) {
            Optional optionalIndividual = GeneticHelper.getIndividual(itemstack);
            if (!optionalIndividual.isPresent()) {
                return;
            }
            IBee individual = (IBee)optionalIndividual.get();
            if (individual.isNatural()) {
                list.add((ITextComponent)new TranslationTextComponent("for.bees.stock.pristine").func_240701_a_(new TextFormatting[]{TextFormatting.YELLOW, TextFormatting.ITALIC}));
            } else {
                list.add((ITextComponent)new TranslationTextComponent("for.bees.stock.ignoble").func_240699_a_(TextFormatting.YELLOW));
            }
        }
        super.func_77624_a(itemstack, world, list, flag);
    }

    public void func_150895_a(ItemGroup tab, NonNullList<ItemStack> subItems) {
        if (this.func_194125_a(tab)) {
            this.addCreativeItems(subItems, true);
        }
    }

    public void addCreativeItems(NonNullList<ItemStack> subItems, boolean hideSecrets) {
        IBeeRoot root = BeeHelper.getRoot();
        for (IBee bee : root.getIndividualTemplates()) {
            if (hideSecrets && bee.isSecret() && !Config.isDebug) continue;
            ItemStack stack = new ItemStack((IItemProvider)this);
            GeneticHelper.setIndividual(stack, bee);
            subItems.add((Object)stack);
        }
    }

    @Override
    public int getColorFromItemStack(ItemStack itemstack, int tintIndex) {
        if (!itemstack.func_77942_o()) {
            if (tintIndex == 1) {
                return 16768022;
            }
            return 0xFFFFFF;
        }
        IAlleleBeeSpecies species = this.getSpecies(itemstack);
        return species.getSpriteColour(tintIndex);
    }

    @Override
    public final EnumBeeType getType() {
        return this.type;
    }
}

