/*
 * Decompiled with CFR 0.152.
 */
package forestry.apiculture.items;

import forestry.api.core.ItemGroups;
import forestry.apiculture.features.ApicultureItems;
import forestry.apiculture.items.EnumHoneyComb;
import forestry.core.items.ItemForestry;
import forestry.core.items.definitions.IColoredItem;
import java.util.ArrayList;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

public class ItemHoneyComb
extends ItemForestry
implements IColoredItem {
    private final EnumHoneyComb type;

    public ItemHoneyComb(EnumHoneyComb type) {
        super(new Item.Properties().func_200916_a(ItemGroups.tabApiculture));
        this.type = type;
    }

    @Nullable
    public static EnumHoneyComb getRandomCombType(Random random, boolean includeSecret) {
        ArrayList<EnumHoneyComb> validCombs = new ArrayList<EnumHoneyComb>(EnumHoneyComb.VALUES.length);
        for (int i = 0; i < EnumHoneyComb.VALUES.length; ++i) {
            EnumHoneyComb honeyComb = EnumHoneyComb.get(i);
            if (honeyComb.isSecret() && !includeSecret) continue;
            validCombs.add(honeyComb);
        }
        if (validCombs.isEmpty()) {
            return null;
        }
        return (EnumHoneyComb)validCombs.get(random.nextInt(validCombs.size()));
    }

    public static ItemStack getRandomComb(int amount, Random random, boolean includeSecret) {
        EnumHoneyComb comb = ItemHoneyComb.getRandomCombType(random, includeSecret);
        return comb != null ? ApicultureItems.BEE_COMBS.stack(comb, amount) : ItemStack.field_190927_a;
    }

    @Override
    public int getColorFromItemStack(ItemStack itemstack, int tintIndex) {
        EnumHoneyComb honeyComb = this.type;
        if (tintIndex == 1) {
            return honeyComb.primaryColor;
        }
        return honeyComb.secondaryColor;
    }
}

