/*
 * Decompiled with CFR 0.152.
 */
package forestry.apiculture.multiblock;

import forestry.api.climate.IClimateControlled;
import forestry.api.multiblock.IAlvearyComponent;
import forestry.api.recipes.IHygroregulatorRecipe;
import forestry.api.recipes.RecipeManagers;
import forestry.apiculture.blocks.BlockAlvearyType;
import forestry.apiculture.gui.ContainerAlvearyHygroregulator;
import forestry.apiculture.inventory.InventoryHygroregulator;
import forestry.apiculture.multiblock.TileAlveary;
import forestry.core.fluids.FilteredTank;
import forestry.core.fluids.FluidHelper;
import forestry.core.fluids.TankManager;
import forestry.core.inventory.IInventoryAdapter;
import forestry.core.tiles.ILiquidTankTile;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.Direction;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;

public class TileAlvearyHygroregulator
extends TileAlveary
implements IInventory,
ILiquidTankTile,
IAlvearyComponent.Climatiser {
    private final TankManager tankManager;
    private final FilteredTank liquidTank;
    private final IInventoryAdapter inventory = new InventoryHygroregulator(this);
    @Nullable
    private IHygroregulatorRecipe currentRecipe;
    private int transferTime;

    public TileAlvearyHygroregulator() {
        super(BlockAlvearyType.HYGRO);
        this.liquidTank = new FilteredTank(10000).setFilters(() -> RecipeManagers.hygroregulatorManager.getRecipeFluids(this.field_145850_b.func_199532_z()));
        this.tankManager = new TankManager(this, this.liquidTank);
    }

    @Override
    public IInventoryAdapter getInternalInventory() {
        return this.inventory;
    }

    @Override
    public boolean allowsAutomation() {
        return true;
    }

    @Override
    public void changeClimate(int tickCount, IClimateControlled climateControlled) {
        FluidStack fluid;
        if (this.transferTime <= 0 && !(fluid = this.liquidTank.getFluid()).isEmpty()) {
            this.currentRecipe = RecipeManagers.hygroregulatorManager.findMatchingRecipe(this.field_145850_b.func_199532_z(), fluid);
            if (this.currentRecipe != null) {
                this.liquidTank.drainInternal(this.currentRecipe.getResource().getAmount(), IFluidHandler.FluidAction.EXECUTE);
                this.transferTime = this.currentRecipe.getTransferTime();
            }
        }
        if (this.transferTime > 0) {
            --this.transferTime;
            if (this.currentRecipe != null) {
                climateControlled.addHumidityChange(this.currentRecipe.getHumidChange(), 0.0f, 1.0f);
                climateControlled.addTemperatureChange(this.currentRecipe.getTempChange(), 0.0f, 2.0f);
            } else {
                this.transferTime = 0;
            }
        }
        if (tickCount % 20 == 0) {
            FluidHelper.drainContainers(this.tankManager, this, 0);
        }
    }

    @Override
    public void func_230337_a_(BlockState state, CompoundNBT compoundNBT) {
        super.func_230337_a_(state, compoundNBT);
        this.tankManager.read(compoundNBT);
        this.transferTime = compoundNBT.func_74762_e("TransferTime");
        if (compoundNBT.func_74764_b("CurrentLiquid")) {
            FluidStack liquid = FluidStack.loadFluidStackFromNBT((CompoundNBT)compoundNBT.func_74775_l("CurrentLiquid"));
            this.currentRecipe = RecipeManagers.hygroregulatorManager.findMatchingRecipe(this.field_145850_b.func_199532_z(), liquid);
        }
    }

    @Override
    public CompoundNBT func_189515_b(CompoundNBT compoundNBT) {
        compoundNBT = super.func_189515_b(compoundNBT);
        this.tankManager.write(compoundNBT);
        compoundNBT.func_74768_a("TransferTime", this.transferTime);
        if (this.currentRecipe != null) {
            CompoundNBT subcompound = new CompoundNBT();
            this.currentRecipe.getResource().writeToNBT(subcompound);
            compoundNBT.func_218657_a("CurrentLiquid", (INBT)subcompound);
        }
        return compoundNBT;
    }

    @Override
    public TankManager getTankManager() {
        return this.tankManager;
    }

    @Override
    public <T> LazyOptional<T> getCapability(Capability<T> capability, @Nullable Direction facing) {
        LazyOptional<T> superCap = super.getCapability(capability, facing);
        if (superCap.isPresent()) {
            return superCap;
        }
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return LazyOptional.of(() -> this.tankManager).cast();
        }
        return LazyOptional.empty();
    }

    @Override
    public Container createMenu(int windowId, PlayerInventory inv, PlayerEntity player) {
        return new ContainerAlvearyHygroregulator(windowId, inv, this);
    }
}

