/*
 * Decompiled with CFR 0.152.
 */
package forestry.apiculture.multiblock;

import forestry.api.apiculture.DefaultBeeListener;
import forestry.api.apiculture.IBeeListener;
import forestry.api.arboriculture.genetics.EnumGermlingType;
import forestry.api.genetics.IForestrySpeciesRoot;
import forestry.api.multiblock.IAlvearyComponent;
import forestry.apiculture.blocks.BlockAlvearyType;
import forestry.apiculture.gui.ContainerAlvearySieve;
import forestry.apiculture.inventory.InventoryAlvearySieve;
import forestry.apiculture.multiblock.TileAlveary;
import forestry.core.inventory.IInventoryAdapter;
import forestry.core.inventory.watchers.ISlotPickupWatcher;
import genetics.api.GeneticsAPI;
import genetics.api.individual.IIndividual;
import genetics.api.root.IRootDefinition;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.item.ItemStack;

public class TileAlvearySieve
extends TileAlveary
implements IAlvearyComponent.BeeListener {
    private final IBeeListener beeListener;
    private final InventoryAlvearySieve inventory = new InventoryAlvearySieve(this);

    public TileAlvearySieve() {
        super(BlockAlvearyType.SIEVE);
        this.beeListener = new AlvearySieveBeeListener(this.inventory);
    }

    @Override
    public IInventoryAdapter getInternalInventory() {
        return this.inventory;
    }

    public ISlotPickupWatcher getCrafter() {
        return this.inventory;
    }

    @Override
    public IBeeListener getBeeListener() {
        return this.beeListener;
    }

    @Override
    public Container createMenu(int windowId, PlayerInventory inv, PlayerEntity player) {
        return new ContainerAlvearySieve(windowId, inv, this);
    }

    static class AlvearySieveBeeListener
    extends DefaultBeeListener {
        private final InventoryAlvearySieve inventory;

        public AlvearySieveBeeListener(InventoryAlvearySieve inventory) {
            this.inventory = inventory;
        }

        @Override
        public boolean onPollenRetrieved(IIndividual pollen) {
            if (!this.inventory.canStorePollen()) {
                return false;
            }
            IRootDefinition definition = GeneticsAPI.apiInstance.getRootHelper().getSpeciesRoot(pollen);
            if (!definition.isPresent()) {
                return false;
            }
            IForestrySpeciesRoot root = (IForestrySpeciesRoot)definition.get();
            ItemStack pollenStack = root.getTypes().createStack(pollen, EnumGermlingType.POLLEN);
            if (!pollenStack.func_190926_b()) {
                this.inventory.storePollenStack(pollenStack);
                return true;
            }
            return false;
        }
    }
}

