/*
 * Decompiled with CFR 0.152.
 */
package forestry.apiculture.multiblock;

import forestry.api.apiculture.BeeManager;
import forestry.api.apiculture.genetics.EnumBeeType;
import forestry.api.apiculture.genetics.IBee;
import forestry.api.multiblock.IAlvearyComponent;
import forestry.apiculture.blocks.BlockAlvearyType;
import forestry.apiculture.gui.ContainerAlvearySwarmer;
import forestry.apiculture.inventory.InventorySwarmer;
import forestry.apiculture.multiblock.MultiblockLogicAlveary;
import forestry.apiculture.multiblock.TileAlveary;
import forestry.apiculture.worldgen.Hive;
import forestry.apiculture.worldgen.HiveDecorator;
import forestry.apiculture.worldgen.HiveDescriptionSwarmer;
import forestry.core.inventory.IInventoryAdapter;
import forestry.core.network.packets.PacketActiveUpdate;
import forestry.core.tiles.IActivatable;
import forestry.core.utils.ItemStackUtil;
import forestry.core.utils.NetworkUtil;
import forestry.core.utils.WorldUtils;
import java.util.Map;
import java.util.Optional;
import java.util.Stack;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.IWorld;

public class TileAlvearySwarmer
extends TileAlveary
implements ISidedInventory,
IActivatable,
IAlvearyComponent.Active {
    private final InventorySwarmer inventory;
    private final Stack<ItemStack> pendingSpawns = new Stack();
    private boolean active;

    public TileAlvearySwarmer() {
        super(BlockAlvearyType.SWARMER);
        this.inventory = new InventorySwarmer(this);
    }

    @Override
    public IInventoryAdapter getInternalInventory() {
        return this.inventory;
    }

    @Override
    public boolean allowsAutomation() {
        return true;
    }

    @Override
    public void updateServer(int tickCount) {
        if (!this.pendingSpawns.isEmpty()) {
            this.setActive(true);
            if (tickCount % 1000 == 0) {
                this.trySpawnSwarm();
            }
        } else {
            this.setActive(false);
        }
        if (tickCount % 500 != 0) {
            return;
        }
        ItemStack princessStack = this.getPrincessStack();
        if (princessStack == null) {
            return;
        }
        int chance = this.consumeInducerAndGetChance();
        if (chance == 0) {
            return;
        }
        if (this.field_145850_b.field_73012_v.nextInt(1000) >= chance) {
            return;
        }
        Optional optionalPrincess = BeeManager.beeRoot.create(princessStack);
        if (!optionalPrincess.isPresent()) {
            return;
        }
        IBee princess = (IBee)optionalPrincess.get();
        princess.setIsNatural(false);
        this.pendingSpawns.push(BeeManager.beeRoot.getTypes().createStack(princess, EnumBeeType.PRINCESS));
    }

    @Override
    public void updateClient(int tickCount) {
    }

    @Nullable
    private ItemStack getPrincessStack() {
        ItemStack princessStack = ((MultiblockLogicAlveary)this.getMultiblockLogic()).getController().getBeeInventory().getQueen();
        if (BeeManager.beeRoot.isMated(princessStack)) {
            return princessStack;
        }
        return null;
    }

    private int consumeInducerAndGetChance() {
        for (int slotIndex = 0; slotIndex < this.func_70302_i_(); ++slotIndex) {
            ItemStack stack = this.func_70301_a(slotIndex);
            for (Map.Entry<ItemStack, Integer> entry : BeeManager.inducers.entrySet()) {
                if (!ItemStackUtil.isIdenticalItem(entry.getKey(), stack)) continue;
                this.func_70298_a(slotIndex, 1);
                return entry.getValue();
            }
        }
        return 0;
    }

    private void trySpawnSwarm() {
        ItemStack toSpawn = this.pendingSpawns.peek();
        HiveDescriptionSwarmer hiveDescription = new HiveDescriptionSwarmer(toSpawn);
        Hive hive = new Hive(hiveDescription);
        int x = this.func_174877_v().func_177958_n() + this.field_145850_b.field_73012_v.nextInt(80) - 40;
        int z = this.func_174877_v().func_177952_p() + this.field_145850_b.field_73012_v.nextInt(80) - 40;
        if (HiveDecorator.tryGenHive((ISeedReader)WorldUtils.asServer((IWorld)this.field_145850_b), this.field_145850_b.field_73012_v, x, z, hive)) {
            this.pendingSpawns.pop();
        }
    }

    @Override
    protected void encodeDescriptionPacket(CompoundNBT packetData) {
        super.encodeDescriptionPacket(packetData);
        packetData.func_74757_a("Active", this.active);
    }

    @Override
    protected void decodeDescriptionPacket(CompoundNBT packetData) {
        super.decodeDescriptionPacket(packetData);
        this.setActive(packetData.func_74767_n("Active"));
    }

    @Override
    public void func_230337_a_(BlockState state, CompoundNBT compoundNBT) {
        super.func_230337_a_(state, compoundNBT);
        this.setActive(compoundNBT.func_74767_n("Active"));
        ListNBT nbttaglist = compoundNBT.func_150295_c("PendingSpawns", 10);
        for (int i = 0; i < nbttaglist.size(); ++i) {
            CompoundNBT compoundNBT1 = nbttaglist.func_150305_b(i);
            this.pendingSpawns.add(ItemStack.func_199557_a((CompoundNBT)compoundNBT1));
        }
    }

    @Override
    public CompoundNBT func_189515_b(CompoundNBT compoundNBT) {
        compoundNBT = super.func_189515_b(compoundNBT);
        compoundNBT.func_74757_a("Active", this.active);
        ListNBT nbttaglist = new ListNBT();
        ItemStack[] offspring = this.pendingSpawns.toArray(new ItemStack[0]);
        for (int i = 0; i < offspring.length; ++i) {
            if (offspring[i] == null) continue;
            CompoundNBT compoundNBT1 = new CompoundNBT();
            compoundNBT1.func_74774_a("Slot", (byte)i);
            offspring[i].func_77955_b(compoundNBT1);
            nbttaglist.add((Object)compoundNBT1);
        }
        compoundNBT.func_218657_a("PendingSpawns", (INBT)nbttaglist);
        return compoundNBT;
    }

    @Override
    public boolean isActive() {
        return this.active;
    }

    @Override
    public void setActive(boolean active) {
        if (this.active == active) {
            return;
        }
        this.active = active;
        if (this.field_145850_b != null && !this.field_145850_b.field_72995_K) {
            NetworkUtil.sendNetworkPacket(new PacketActiveUpdate(this), this.field_174879_c, this.field_145850_b);
        }
    }

    @Override
    public Container createMenu(int windowId, PlayerInventory inv, PlayerEntity player) {
        return new ContainerAlvearySwarmer(windowId, inv, this);
    }
}

