/*
 * Decompiled with CFR 0.152.
 */
package forestry.apiculture.network.packets;

import forestry.api.apiculture.IBeeHousing;
import forestry.api.apiculture.IBeekeepingLogic;
import forestry.core.network.ForestryPacket;
import forestry.core.network.IForestryPacketClient;
import forestry.core.network.IForestryPacketHandlerClient;
import forestry.core.network.PacketBufferForestry;
import forestry.core.network.PacketIdClient;
import forestry.core.tiles.TileUtil;
import java.io.IOException;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class PacketBeeLogicActive
extends ForestryPacket
implements IForestryPacketClient {
    private final BlockPos tilePos;
    private final IBeekeepingLogic beekeepingLogic;

    public PacketBeeLogicActive(IBeeHousing tile) {
        this.tilePos = tile.getCoordinates();
        this.beekeepingLogic = tile.getBeekeepingLogic();
    }

    @Override
    public PacketIdClient getPacketId() {
        return PacketIdClient.BEE_LOGIC_ACTIVE;
    }

    @Override
    protected void writeData(PacketBufferForestry data) {
        data.func_179255_a(this.tilePos);
        this.beekeepingLogic.writeData(data);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class Handler
    implements IForestryPacketHandlerClient {
        @Override
        public void onPacketData(PacketBufferForestry data, PlayerEntity player) throws IOException {
            BlockPos tilePos = data.func_179259_c();
            IBeeHousing beeHousing = TileUtil.getTile((IBlockReader)player.field_70170_p, tilePos, IBeeHousing.class);
            if (beeHousing != null) {
                IBeekeepingLogic beekeepingLogic = beeHousing.getBeekeepingLogic();
                beekeepingLogic.readData(data);
            }
        }
    }
}

