/*
 * Decompiled with CFR 0.152.
 */
package forestry.apiculture.network.packets;

import forestry.api.apiculture.IBeeHousing;
import forestry.api.apiculture.IBeekeepingLogic;
import forestry.apiculture.BeekeepingLogic;
import forestry.core.network.ForestryPacket;
import forestry.core.network.IForestryPacketClient;
import forestry.core.network.IForestryPacketHandlerClient;
import forestry.core.network.PacketBufferForestry;
import forestry.core.network.PacketIdClient;
import java.io.IOException;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class PacketBeeLogicActiveEntity
extends ForestryPacket
implements IForestryPacketClient {
    private final Entity entity;
    private final BeekeepingLogic beekeepingLogic;

    public PacketBeeLogicActiveEntity(IBeeHousing housing, Entity entity) {
        this.entity = entity;
        this.beekeepingLogic = (BeekeepingLogic)housing.getBeekeepingLogic();
    }

    @Override
    public PacketIdClient getPacketId() {
        return PacketIdClient.BEE_LOGIC_ACTIVE_ENTITY;
    }

    @Override
    protected void writeData(PacketBufferForestry data) {
        data.writeEntityById(this.entity);
        this.beekeepingLogic.writeData(data);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class Handler
    implements IForestryPacketHandlerClient {
        @Override
        public void onPacketData(PacketBufferForestry data, PlayerEntity player) throws IOException {
            IBeeHousing beeHousing;
            IBeekeepingLogic beekeepingLogic;
            Entity entity = data.readEntityById(player.field_70170_p);
            if (entity instanceof IBeeHousing && (beekeepingLogic = (beeHousing = (IBeeHousing)entity).getBeekeepingLogic()) instanceof BeekeepingLogic) {
                beekeepingLogic.readData(data);
            }
        }
    }
}

