/*
 * Decompiled with CFR 0.152.
 */
package forestry.apiculture.tiles;

import com.mojang.authlib.GameProfile;
import forestry.api.apiculture.BeeManager;
import forestry.api.apiculture.IBeeHousing;
import forestry.api.apiculture.IBeekeepingLogic;
import forestry.api.climate.ClimateCapabilities;
import forestry.api.climate.IClimatised;
import forestry.api.core.EnumHumidity;
import forestry.api.core.EnumTemperature;
import forestry.apiculture.gui.IGuiBeeHousingDelegate;
import forestry.core.climate.ClimateListener;
import forestry.core.network.IStreamableGui;
import forestry.core.network.PacketBufferForestry;
import forestry.core.owner.IOwnedTile;
import forestry.core.owner.IOwnerHandler;
import forestry.core.owner.OwnerHandler;
import forestry.core.render.ParticleRender;
import forestry.core.tiles.TileBase;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;

public abstract class TileBeeHousingBase
extends TileBase
implements IBeeHousing,
IOwnedTile,
IClimatised,
IGuiBeeHousingDelegate,
IStreamableGui {
    private final String hintKey;
    private final OwnerHandler ownerHandler = new OwnerHandler();
    private final IBeekeepingLogic beeLogic;
    protected final ClimateListener climateListener;
    private int breedingProgressPercent = 0;

    protected TileBeeHousingBase(TileEntityType<?> type, String hintKey) {
        super(type);
        this.hintKey = hintKey;
        this.beeLogic = BeeManager.beeRoot.createBeekeepingLogic(this);
        this.climateListener = new ClimateListener(this);
    }

    @Override
    public String getHintKey() {
        return this.hintKey;
    }

    @Override
    public IBeekeepingLogic getBeekeepingLogic() {
        return this.beeLogic;
    }

    @Override
    public CompoundNBT func_189515_b(CompoundNBT compoundNBT) {
        compoundNBT = super.func_189515_b(compoundNBT);
        this.beeLogic.write(compoundNBT);
        this.ownerHandler.write(compoundNBT);
        return compoundNBT;
    }

    @Override
    public void func_230337_a_(BlockState state, CompoundNBT compoundNBT) {
        super.func_230337_a_(state, compoundNBT);
        this.beeLogic.read(compoundNBT);
        this.ownerHandler.read(compoundNBT);
    }

    @Override
    public CompoundNBT func_189517_E_() {
        CompoundNBT updateTag = super.func_189517_E_();
        this.beeLogic.write(updateTag);
        this.ownerHandler.write(updateTag);
        return updateTag;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void handleUpdateTag(BlockState state, CompoundNBT tag) {
        super.handleUpdateTag(state, tag);
        this.beeLogic.read(tag);
        this.ownerHandler.read(tag);
    }

    @Override
    public IOwnerHandler getOwnerHandler() {
        return this.ownerHandler;
    }

    @Override
    public EnumTemperature getTemperature() {
        return this.climateListener.getTemperature();
    }

    @Override
    public EnumHumidity getHumidity() {
        return this.climateListener.getHumidity();
    }

    @Override
    public float getExactTemperature() {
        return this.climateListener.getExactTemperature();
    }

    @Override
    public float getExactHumidity() {
        return this.climateListener.getExactHumidity();
    }

    @Override
    public <T> LazyOptional<T> getCapability(Capability<T> capability, @Nullable Direction facing) {
        if (capability == ClimateCapabilities.CLIMATE_LISTENER) {
            return LazyOptional.of(() -> this.climateListener).cast();
        }
        return super.getCapability(capability, facing);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void updateClientSide() {
        if (this.beeLogic.canDoBeeFX() && this.updateOnInterval(4)) {
            this.beeLogic.doBeeFX();
            if (this.updateOnInterval(50)) {
                TileBeeHousingBase.doPollenFX(this.field_145850_b, this.func_174877_v().func_177958_n(), this.func_174877_v().func_177956_o(), this.func_174877_v().func_177952_p());
            }
        }
        this.climateListener.updateClientSide(true);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void doPollenFX(World world, double xCoord, double yCoord, double zCoord) {
        double fxX = xCoord + 0.5;
        double fxY = yCoord + 0.25;
        double fxZ = zCoord + 0.5;
        float distanceFromCenter = 0.6f;
        float leftRightSpreadFromCenter = distanceFromCenter * (world.field_73012_v.nextFloat() - 0.5f);
        float upSpread = world.field_73012_v.nextFloat() * 6.0f / 16.0f;
        ParticleRender.addEntityHoneyDustFX(world, fxX - (double)distanceFromCenter, fxY += (double)upSpread, fxZ + (double)leftRightSpreadFromCenter);
        ParticleRender.addEntityHoneyDustFX(world, fxX + (double)distanceFromCenter, fxY, fxZ + (double)leftRightSpreadFromCenter);
        ParticleRender.addEntityHoneyDustFX(world, fxX + (double)leftRightSpreadFromCenter, fxY, fxZ - (double)distanceFromCenter);
        ParticleRender.addEntityHoneyDustFX(world, fxX + (double)leftRightSpreadFromCenter, fxY, fxZ + (double)distanceFromCenter);
    }

    @Override
    public void updateServerSide() {
        if (this.beeLogic.canWork()) {
            this.beeLogic.doWork();
        }
    }

    @Override
    public int getHealthScaled(int i) {
        return this.breedingProgressPercent * i / 100;
    }

    @Override
    public void writeGuiData(PacketBufferForestry data) {
        data.func_150787_b(this.beeLogic.getBeeProgressPercent());
    }

    @Override
    public void readGuiData(PacketBufferForestry data) {
        this.breedingProgressPercent = data.func_150792_a();
    }

    @Override
    public Biome getBiome() {
        return this.field_145850_b.func_226691_t_(this.func_174877_v());
    }

    @Override
    public int getBlockLightValue() {
        return this.field_145850_b.func_201696_r(this.func_174877_v().func_177984_a());
    }

    @Override
    public boolean canBlockSeeTheSky() {
        return this.field_145850_b.func_175710_j(this.func_174877_v().func_177984_a());
    }

    @Override
    public boolean isRaining() {
        return this.field_145850_b.func_175727_C(this.func_174877_v().func_177984_a());
    }

    @Override
    public GameProfile getOwner() {
        return this.getOwnerHandler().getOwner();
    }

    @Override
    public Vector3d getBeeFXCoordinates() {
        return new Vector3d((double)this.func_174877_v().func_177958_n() + 0.5, (double)this.func_174877_v().func_177956_o() + 0.5, (double)this.func_174877_v().func_177952_p() + 0.5);
    }
}

