/*
 * Decompiled with CFR 0.152.
 */
package forestry.apiculture.worldgen;

import forestry.apiculture.worldgen.HiveGen;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.material.Material;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.gen.Heightmap;

public class HiveGenGround
extends HiveGen {
    private final Set<Material> groundMaterials = new HashSet<Material>();

    public HiveGenGround(Block ... groundBlocks) {
        for (Block block : groundBlocks) {
            BlockState blockState = block.func_176223_P();
            Material blockMaterial = blockState.func_185904_a();
            this.groundMaterials.add(blockMaterial);
        }
    }

    @Override
    public boolean isValidLocation(ISeedReader world, BlockPos pos) {
        BlockState groundBlockState = world.func_180495_p(pos.func_177977_b());
        Material groundBlockMaterial = groundBlockState.func_185904_a();
        return this.groundMaterials.contains(groundBlockMaterial);
    }

    @Override
    public BlockPos getPosForHive(ISeedReader world, int x, int z) {
        BlockPos topPos = world.func_205770_a(Heightmap.Type.WORLD_SURFACE_WG, new BlockPos(x, 0, z));
        if (topPos.func_177956_o() == 0) {
            return null;
        }
        BlockPos.Mutable pos = new BlockPos.Mutable();
        pos.func_189533_g((Vector3i)topPos);
        BlockState blockState = world.func_180495_p((BlockPos)pos);
        while (HiveGenGround.isTreeBlock(blockState, world, (BlockPos)pos) || this.canReplace(blockState, world, (BlockPos)pos)) {
            pos.func_189536_c(Direction.DOWN);
            if (pos.func_177956_o() <= 0) {
                return null;
            }
            blockState = world.func_180495_p((BlockPos)pos);
        }
        return pos.func_177984_a();
    }
}

