/*
 * Decompiled with CFR 0.152.
 */
package forestry.arboriculture;

import forestry.api.genetics.IFruitFamily;
import forestry.api.genetics.products.IProductList;
import forestry.api.genetics.products.Product;
import forestry.arboriculture.FruitProviderNone;
import forestry.core.genetics.ProductListWrapper;
import genetics.api.individual.IGenome;
import java.awt.Color;
import java.util.function.Supplier;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;

public class FruitProviderRipening
extends FruitProviderNone {
    private int colourCallow = 0xFFFFFF;
    private int diffR;
    private int diffG;
    private int diffB;
    private ProductListWrapper products = ProductListWrapper.create();

    public FruitProviderRipening(String unlocalizedDescription, IFruitFamily family, Supplier<ItemStack> product, float modifier) {
        super(unlocalizedDescription, family);
        this.products.addProduct(product, modifier);
    }

    @Override
    public void onStartSetup() {
        this.products = this.products.bake();
    }

    public FruitProviderRipening setColours(Color ripe, Color callow) {
        this.colourCallow = callow.getRGB();
        int ripeRGB = ripe.getRGB();
        this.diffR = (ripeRGB >> 16 & 0xFF) - (this.colourCallow >> 16 & 0xFF);
        this.diffG = (ripeRGB >> 8 & 0xFF) - (this.colourCallow >> 8 & 0xFF);
        this.diffB = (ripeRGB & 0xFF) - (this.colourCallow & 0xFF);
        return this;
    }

    public FruitProviderRipening setRipeningPeriod(int period) {
        this.ripeningPeriod = period;
        return this;
    }

    private float getRipeningStage(int ripeningTime) {
        if (ripeningTime >= this.ripeningPeriod) {
            return 1.0f;
        }
        return (float)ripeningTime / (float)this.ripeningPeriod;
    }

    @Override
    public NonNullList<ItemStack> getFruits(IGenome genome, World world, BlockPos pos, int ripeningTime) {
        NonNullList product = NonNullList.func_191196_a();
        this.products.addProducts((IBlockReader)world, pos, (NonNullList<ItemStack>)product, Product::getChance, world.field_73012_v);
        return product;
    }

    @Override
    public IProductList getProducts() {
        return this.products;
    }

    @Override
    public boolean isFruitLeaf(IGenome genome, IWorld world, BlockPos pos) {
        return true;
    }

    @Override
    public int getColour(IGenome genome, IBlockReader world, BlockPos pos, int ripeningTime) {
        float stage = this.getRipeningStage(ripeningTime);
        return this.getColour(stage);
    }

    private int getColour(float stage) {
        int r = (this.colourCallow >> 16 & 0xFF) + (int)((float)this.diffR * stage);
        int g = (this.colourCallow >> 8 & 0xFF) + (int)((float)this.diffG * stage);
        int b = (this.colourCallow & 0xFF) + (int)((float)this.diffB * stage);
        return (r & 0xFF) << 16 | (g & 0xFF) << 8 | b & 0xFF;
    }

    @Override
    public int getDecorativeColor() {
        return this.getColour(1.0f);
    }
}

