/*
 * Decompiled with CFR 0.152.
 */
package forestry.arboriculture;

import forestry.api.arboriculture.genetics.IAlleleTreeSpecies;
import forestry.api.arboriculture.genetics.TreeChromosomes;
import forestry.core.config.LocalizedConfiguration;
import forestry.core.utils.Log;
import genetics.api.alleles.IAllele;
import genetics.utils.AlleleUtils;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.registries.ForgeRegistries;

public class TreeConfig {
    public static final String CONFIG_CATEGORY_TREE = "trees";
    public static final String CONFIG_COMMENT = "This config can be used to customise the world generation for all trees that where added by forestry or\nby an addon mod like extra trees.\n\n# The spawn rarity of the tree species in the world. [range: 0.0 ~ 1.0]\nS:rarity=1.0\n\n# Dimension ids can be added to these lists to blacklist or whitelist them. \ndimensions {\n\tI:blacklist <\n\t\t1\n\t >\n\tI:whitelist <\n\t\t-1\n\t >\n}\n\n# Biome types or registry names can be added to these lists to blacklist them. \nbiomes {\n\tblacklist {\n\t\tS:names <\n\t\t\tminecraft:plains\n\t\t >\n\t\tS:types <\n\t\t\tforest\n\t\t >\n\t}\n}";
    private static final Map<ResourceLocation, TreeConfig> configs = new HashMap<ResourceLocation, TreeConfig>();
    private static final TreeConfig GLOBAL = new TreeConfig(new ResourceLocation("forestry", "global"), 1.0f);
    private final ResourceLocation treeName;
    private final float defaultRarity;
    private final Set<String> blacklistedDimensions = new HashSet<String>();
    private final Set<String> whitelistedDimensions = new HashSet<String>();
    private final Set<Biome.Category> blacklistedBiomeTypes = new HashSet<Biome.Category>();
    private final Set<Biome> blacklistedBiomes = new HashSet<Biome>();
    private float spawnRarity;

    public static void parse(LocalizedConfiguration config) {
        config.setCategoryComment(CONFIG_CATEGORY_TREE, CONFIG_COMMENT);
        config.setCategoryComment("trees.global", "All options defined in the global category are used for all trees.");
        GLOBAL.parseConfig(config);
        for (IAllele iAllele : AlleleUtils.filteredAlleles(TreeChromosomes.SPECIES)) {
            IAlleleTreeSpecies treeSpecies = (IAlleleTreeSpecies)iAllele;
            configs.put(treeSpecies.getRegistryName(), new TreeConfig(treeSpecies.getRegistryName(), treeSpecies.getRarity()).parseConfig(config));
        }
    }

    private TreeConfig(ResourceLocation treeName, float defaultRarity) {
        this.treeName = treeName;
        this.defaultRarity = defaultRarity;
        this.spawnRarity = defaultRarity;
    }

    private TreeConfig parseConfig(LocalizedConfiguration config) {
        this.blacklistedDimensions.addAll(Arrays.asList(config.get("trees." + this.treeName + ".dimensions", "blacklist", new String[0]).getStringList()));
        this.whitelistedDimensions.addAll(Arrays.asList(config.get("trees." + this.treeName + ".dimensions", "whitelist", new String[0]).getStringList()));
        for (String typeName : config.get("trees." + this.treeName + ".biomes.blacklist", "types", new String[0]).getStringList()) {
            this.blacklistedBiomeTypes.add(Biome.Category.func_235103_a_((String)typeName));
        }
        for (String biomeName : config.get("trees." + this.treeName + ".biomes.blacklist", "names", new String[0]).getStringList()) {
            Biome biome = (Biome)ForgeRegistries.BIOMES.getValue(new ResourceLocation(biomeName));
            if (biome != null) {
                this.blacklistedBiomes.add(biome);
                continue;
            }
            Log.error("Failed to identify biome for the config property for the tree with the uid '" + this.treeName + "'. No biome is registered under the registry name '" + biomeName + "'.", new Object[0]);
        }
        this.spawnRarity = (float)config.get("trees." + this.treeName, "rarity", this.defaultRarity).setMinValue(0.0).setMaxValue(1.0).getDouble();
        return this;
    }

    public static void blacklistTreeDim(@Nullable ResourceLocation treeUID, String dimID) {
        TreeConfig treeConfig = configs.get(treeUID);
        if (treeUID == null) {
            treeConfig = GLOBAL;
        }
        treeConfig.blacklistedDimensions.add(dimID);
    }

    public static void whitelistTreeDim(@Nullable ResourceLocation treeUID, String dimID) {
        TreeConfig treeConfig = configs.get(treeUID);
        if (treeUID == null) {
            treeConfig = GLOBAL;
        }
        treeConfig.whitelistedDimensions.add(dimID);
    }

    public static boolean isValidDimension(@Nullable ResourceLocation treeUID, RegistryKey<World> dimID) {
        TreeConfig treeConfig = configs.get(treeUID);
        return treeConfig != null ? treeConfig.isValidDimension(dimID.getRegistryName()) : GLOBAL.isValidDimension(dimID.getRegistryName());
    }

    private boolean isValidDimension(ResourceLocation dimID) {
        if (this.blacklistedDimensions.isEmpty() || !this.blacklistedDimensions.contains(dimID.toString())) {
            return this.whitelistedDimensions.isEmpty() || this.whitelistedDimensions.contains(dimID.toString());
        }
        return false;
    }

    public static boolean isValidBiome(@Nullable ResourceLocation treeUID, Biome biome) {
        TreeConfig treeConfig = configs.get(treeUID);
        return treeUID != null ? treeConfig.isValidBiome(biome) : GLOBAL.isValidBiome(biome);
    }

    private boolean isValidBiome(Biome biome) {
        if (this.blacklistedBiomes.contains(biome)) {
            return false;
        }
        return Arrays.stream(Biome.Category.values()).noneMatch(this.blacklistedBiomeTypes::contains);
    }

    public static float getSpawnRarity(@Nullable ResourceLocation treeUID) {
        TreeConfig treeConfig = configs.get(treeUID);
        if (treeUID == null) {
            treeConfig = GLOBAL;
        }
        return treeConfig.spawnRarity;
    }
}

