/*
 * Decompiled with CFR 0.152.
 */
package forestry.arboriculture;

import com.google.common.base.Preconditions;
import forestry.api.arboriculture.EnumVanillaWoodType;
import forestry.api.arboriculture.IWoodAccess;
import forestry.api.arboriculture.IWoodType;
import forestry.api.arboriculture.WoodBlockKind;
import forestry.arboriculture.IWoodTyped;
import forestry.modules.features.FeatureBlockGroup;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.util.IItemProvider;

public class WoodAccess
implements IWoodAccess {
    @Nullable
    private static WoodAccess INSTANCE;
    private final Map<WoodBlockKind, WoodMap> woodMaps = new EnumMap<WoodBlockKind, WoodMap>(WoodBlockKind.class);
    private final List<IWoodType> registeredWoodTypes = new ArrayList<IWoodType>();

    public static WoodAccess getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new WoodAccess();
        }
        return INSTANCE;
    }

    private WoodAccess() {
        for (WoodBlockKind woodBlockKind : WoodBlockKind.values()) {
            this.woodMaps.put(woodBlockKind, new WoodMap(woodBlockKind));
        }
        this.registerVanilla();
    }

    public <T extends Block> void registerFeatures(FeatureBlockGroup<? extends T, ? extends IWoodType> featureGroup, WoodBlockKind kind) {
        for (Block block : featureGroup.getBlocks()) {
            this.registerWithoutVariants(block, kind);
        }
    }

    private void registerVanilla() {
        this.register(EnumVanillaWoodType.OAK, WoodBlockKind.LOG, false, Blocks.field_196617_K.func_176223_P(), new ItemStack((IItemProvider)Blocks.field_196617_K));
        this.register(EnumVanillaWoodType.SPRUCE, WoodBlockKind.LOG, false, Blocks.field_196618_L.func_176223_P(), new ItemStack((IItemProvider)Blocks.field_196618_L));
        this.register(EnumVanillaWoodType.BIRCH, WoodBlockKind.LOG, false, Blocks.field_196619_M.func_176223_P(), new ItemStack((IItemProvider)Blocks.field_196619_M));
        this.register(EnumVanillaWoodType.JUNGLE, WoodBlockKind.LOG, false, Blocks.field_196620_N.func_176223_P(), new ItemStack((IItemProvider)Blocks.field_196620_N));
        this.register(EnumVanillaWoodType.ACACIA, WoodBlockKind.LOG, false, Blocks.field_196621_O.func_176223_P(), new ItemStack((IItemProvider)Blocks.field_196621_O));
        this.register(EnumVanillaWoodType.DARK_OAK, WoodBlockKind.LOG, false, Blocks.field_196623_P.func_176223_P(), new ItemStack((IItemProvider)Blocks.field_196623_P));
        this.register(EnumVanillaWoodType.OAK, WoodBlockKind.PLANKS, false, Blocks.field_196662_n.func_176223_P(), new ItemStack((IItemProvider)Blocks.field_196662_n));
        this.register(EnumVanillaWoodType.SPRUCE, WoodBlockKind.PLANKS, false, Blocks.field_196664_o.func_176223_P(), new ItemStack((IItemProvider)Blocks.field_196664_o));
        this.register(EnumVanillaWoodType.BIRCH, WoodBlockKind.PLANKS, false, Blocks.field_196666_p.func_176223_P(), new ItemStack((IItemProvider)Blocks.field_196666_p));
        this.register(EnumVanillaWoodType.JUNGLE, WoodBlockKind.PLANKS, false, Blocks.field_196668_q.func_176223_P(), new ItemStack((IItemProvider)Blocks.field_196668_q));
        this.register(EnumVanillaWoodType.ACACIA, WoodBlockKind.PLANKS, false, Blocks.field_196670_r.func_176223_P(), new ItemStack((IItemProvider)Blocks.field_196670_r));
        this.register(EnumVanillaWoodType.DARK_OAK, WoodBlockKind.PLANKS, false, Blocks.field_196672_s.func_176223_P(), new ItemStack((IItemProvider)Blocks.field_196672_s));
        this.register(EnumVanillaWoodType.OAK, WoodBlockKind.SLAB, false, Blocks.field_196622_bq.func_176223_P(), new ItemStack((IItemProvider)Blocks.field_196622_bq));
        this.register(EnumVanillaWoodType.SPRUCE, WoodBlockKind.SLAB, false, Blocks.field_196624_br.func_176223_P(), new ItemStack((IItemProvider)Blocks.field_196624_br));
        this.register(EnumVanillaWoodType.BIRCH, WoodBlockKind.SLAB, false, Blocks.field_196627_bs.func_176223_P(), new ItemStack((IItemProvider)Blocks.field_196627_bs));
        this.register(EnumVanillaWoodType.JUNGLE, WoodBlockKind.SLAB, false, Blocks.field_196630_bt.func_176223_P(), new ItemStack((IItemProvider)Blocks.field_196630_bt));
        this.register(EnumVanillaWoodType.ACACIA, WoodBlockKind.SLAB, false, Blocks.field_196632_bu.func_176223_P(), new ItemStack((IItemProvider)Blocks.field_196632_bu));
        this.register(EnumVanillaWoodType.DARK_OAK, WoodBlockKind.SLAB, false, Blocks.field_196635_bv.func_176223_P(), new ItemStack((IItemProvider)Blocks.field_196635_bv));
        this.register(EnumVanillaWoodType.OAK, WoodBlockKind.LOG, false, Blocks.field_196617_K.func_176223_P(), new ItemStack((IItemProvider)Blocks.field_196617_K));
        this.register(EnumVanillaWoodType.SPRUCE, WoodBlockKind.LOG, false, Blocks.field_196618_L.func_176223_P(), new ItemStack((IItemProvider)Blocks.field_196618_L));
        this.register(EnumVanillaWoodType.BIRCH, WoodBlockKind.LOG, false, Blocks.field_196619_M.func_176223_P(), new ItemStack((IItemProvider)Blocks.field_196619_M));
        this.register(EnumVanillaWoodType.JUNGLE, WoodBlockKind.LOG, false, Blocks.field_196620_N.func_176223_P(), new ItemStack((IItemProvider)Blocks.field_196620_N));
        this.register(EnumVanillaWoodType.ACACIA, WoodBlockKind.LOG, false, Blocks.field_196621_O.func_176223_P(), new ItemStack((IItemProvider)Blocks.field_196621_O));
        this.register(EnumVanillaWoodType.DARK_OAK, WoodBlockKind.LOG, false, Blocks.field_196623_P.func_176223_P(), new ItemStack((IItemProvider)Blocks.field_196623_P));
        this.register(EnumVanillaWoodType.OAK, WoodBlockKind.FENCE, false, Blocks.field_180407_aO.func_176223_P(), new ItemStack((IItemProvider)Blocks.field_180407_aO));
        this.register(EnumVanillaWoodType.SPRUCE, WoodBlockKind.FENCE, false, Blocks.field_180408_aP.func_176223_P(), new ItemStack((IItemProvider)Blocks.field_180408_aP));
        this.register(EnumVanillaWoodType.BIRCH, WoodBlockKind.FENCE, false, Blocks.field_180404_aQ.func_176223_P(), new ItemStack((IItemProvider)Blocks.field_180404_aQ));
        this.register(EnumVanillaWoodType.JUNGLE, WoodBlockKind.FENCE, false, Blocks.field_180403_aR.func_176223_P(), new ItemStack((IItemProvider)Blocks.field_180403_aR));
        this.register(EnumVanillaWoodType.ACACIA, WoodBlockKind.FENCE, false, Blocks.field_180405_aT.func_176223_P(), new ItemStack((IItemProvider)Blocks.field_180405_aT));
        this.register(EnumVanillaWoodType.DARK_OAK, WoodBlockKind.FENCE, false, Blocks.field_180406_aS.func_176223_P(), new ItemStack((IItemProvider)Blocks.field_180406_aS));
        this.register(EnumVanillaWoodType.OAK, WoodBlockKind.FENCE_GATE, false, Blocks.field_180390_bo.func_176223_P(), new ItemStack((IItemProvider)Blocks.field_180390_bo));
        this.register(EnumVanillaWoodType.SPRUCE, WoodBlockKind.FENCE_GATE, false, Blocks.field_180391_bp.func_176223_P(), new ItemStack((IItemProvider)Blocks.field_180391_bp));
        this.register(EnumVanillaWoodType.BIRCH, WoodBlockKind.FENCE_GATE, false, Blocks.field_180392_bq.func_176223_P(), new ItemStack((IItemProvider)Blocks.field_180392_bq));
        this.register(EnumVanillaWoodType.JUNGLE, WoodBlockKind.FENCE_GATE, false, Blocks.field_180386_br.func_176223_P(), new ItemStack((IItemProvider)Blocks.field_180386_br));
        this.register(EnumVanillaWoodType.ACACIA, WoodBlockKind.FENCE_GATE, false, Blocks.field_180387_bt.func_176223_P(), new ItemStack((IItemProvider)Blocks.field_180387_bt));
        this.register(EnumVanillaWoodType.DARK_OAK, WoodBlockKind.FENCE_GATE, false, Blocks.field_180385_bs.func_176223_P(), new ItemStack((IItemProvider)Blocks.field_180385_bs));
        this.register(EnumVanillaWoodType.OAK, WoodBlockKind.STAIRS, false, Blocks.field_150476_ad.func_176223_P(), new ItemStack((IItemProvider)Blocks.field_150476_ad));
        this.register(EnumVanillaWoodType.SPRUCE, WoodBlockKind.STAIRS, false, Blocks.field_150485_bF.func_176223_P(), new ItemStack((IItemProvider)Blocks.field_150485_bF));
        this.register(EnumVanillaWoodType.BIRCH, WoodBlockKind.STAIRS, false, Blocks.field_150487_bG.func_176223_P(), new ItemStack((IItemProvider)Blocks.field_150487_bG));
        this.register(EnumVanillaWoodType.JUNGLE, WoodBlockKind.STAIRS, false, Blocks.field_150481_bH.func_176223_P(), new ItemStack((IItemProvider)Blocks.field_150481_bH));
        this.register(EnumVanillaWoodType.ACACIA, WoodBlockKind.STAIRS, false, Blocks.field_150400_ck.func_176223_P(), new ItemStack((IItemProvider)Blocks.field_150400_ck));
        this.register(EnumVanillaWoodType.DARK_OAK, WoodBlockKind.STAIRS, false, Blocks.field_150401_cl.func_176223_P(), new ItemStack((IItemProvider)Blocks.field_150401_cl));
        this.register(EnumVanillaWoodType.OAK, WoodBlockKind.DOOR, false, Blocks.field_180413_ao.func_176223_P(), new ItemStack((IItemProvider)Items.field_222015_iN));
        this.register(EnumVanillaWoodType.SPRUCE, WoodBlockKind.DOOR, false, Blocks.field_180414_ap.func_176223_P(), new ItemStack((IItemProvider)Items.field_222017_iO));
        this.register(EnumVanillaWoodType.BIRCH, WoodBlockKind.DOOR, false, Blocks.field_180412_aq.func_176223_P(), new ItemStack((IItemProvider)Items.field_222019_iP));
        this.register(EnumVanillaWoodType.JUNGLE, WoodBlockKind.DOOR, false, Blocks.field_180411_ar.func_176223_P(), new ItemStack((IItemProvider)Items.field_222021_iQ));
        this.register(EnumVanillaWoodType.ACACIA, WoodBlockKind.DOOR, false, Blocks.field_180410_as.func_176223_P(), new ItemStack((IItemProvider)Items.field_222023_iR));
        this.register(EnumVanillaWoodType.DARK_OAK, WoodBlockKind.DOOR, false, Blocks.field_180409_at.func_176223_P(), new ItemStack((IItemProvider)Items.field_222025_iS));
    }

    private <T extends Block> void registerWithoutVariants(T woodTyped, WoodBlockKind woodBlockKind) {
        boolean fireproof = ((IWoodTyped)woodTyped).isFireproof();
        BlockState blockState = woodTyped.func_176223_P();
        IWoodType woodType = ((IWoodTyped)woodTyped).getWoodType();
        ItemStack itemStack = new ItemStack(woodTyped);
        if (itemStack.func_190926_b()) {
            new ItemStack(woodTyped);
        }
        this.register(woodType, woodBlockKind, fireproof, blockState, itemStack);
    }

    @Override
    public void register(IWoodType woodType, WoodBlockKind woodBlockKind, boolean fireproof, BlockState blockState, ItemStack itemStack) {
        if (woodBlockKind == WoodBlockKind.DOOR) {
            fireproof = true;
        }
        Preconditions.checkArgument((!itemStack.func_190926_b() ? 1 : 0) != 0, (Object)"Empty Itemstack");
        WoodMap woodMap = this.woodMaps.get((Object)woodBlockKind);
        if (!this.registeredWoodTypes.contains(woodType)) {
            this.registeredWoodTypes.add(woodType);
        }
        woodMap.getItem(fireproof).put(woodType, itemStack);
        woodMap.getBlock(fireproof).put(woodType, blockState);
    }

    @Override
    public ItemStack getStack(IWoodType woodType, WoodBlockKind woodBlockKind, boolean fireproof) {
        WoodMap woodMap;
        ItemStack itemStack;
        if (woodBlockKind == WoodBlockKind.DOOR) {
            fireproof = true;
        }
        if ((itemStack = (woodMap = this.woodMaps.get((Object)woodBlockKind)).getItem(fireproof).get(woodType)) == null) {
            String errMessage = String.format("No stack found for %s %s %s", woodType, woodMap.getName(), fireproof ? "fireproof" : "non-fireproof");
            throw new IllegalStateException(errMessage);
        }
        return itemStack.func_77946_l();
    }

    @Override
    public BlockState getBlock(IWoodType woodType, WoodBlockKind woodBlockKind, boolean fireproof) {
        WoodMap woodMap;
        BlockState blockState;
        if (woodBlockKind == WoodBlockKind.DOOR) {
            fireproof = true;
        }
        if ((blockState = (woodMap = this.woodMaps.get((Object)woodBlockKind)).getBlock(fireproof).get(woodType)) == null) {
            String errMessage = String.format("No block found for %s %s %s", woodType, woodMap.getName(), fireproof ? "fireproof" : "non-fireproof");
            throw new IllegalStateException(errMessage);
        }
        return blockState;
    }

    @Override
    public List<IWoodType> getRegisteredWoodTypes() {
        return this.registeredWoodTypes;
    }

    private static class WoodMap {
        private final Map<IWoodType, ItemStack> normalItems = new HashMap<IWoodType, ItemStack>();
        private final Map<IWoodType, ItemStack> fireproofItems = new HashMap<IWoodType, ItemStack>();
        private final Map<IWoodType, BlockState> normalBlocks = new HashMap<IWoodType, BlockState>();
        private final Map<IWoodType, BlockState> fireproofBlocks = new HashMap<IWoodType, BlockState>();
        private final WoodBlockKind woodBlockKind;

        public WoodMap(WoodBlockKind woodBlockKind) {
            this.woodBlockKind = woodBlockKind;
        }

        public String getName() {
            return this.woodBlockKind.name();
        }

        public Map<IWoodType, ItemStack> getItem(boolean fireproof) {
            return fireproof ? this.fireproofItems : this.normalItems;
        }

        public Map<IWoodType, BlockState> getBlock(boolean fireproof) {
            return fireproof ? this.fireproofBlocks : this.normalBlocks;
        }
    }
}

