/*
 * Decompiled with CFR 0.152.
 */
package forestry.arboriculture.blocks;

import com.mojang.authlib.GameProfile;
import forestry.api.arboriculture.genetics.IAlleleTreeSpecies;
import forestry.api.arboriculture.genetics.ITree;
import forestry.api.arboriculture.genetics.TreeChromosomes;
import forestry.arboriculture.genetics.TreeDefinition;
import forestry.core.blocks.IColoredBlock;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.BlockState;
import net.minecraft.block.LeavesBlock;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.loot.LootContext;
import net.minecraft.util.Direction;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;

public abstract class BlockAbstractLeaves
extends LeavesBlock
implements IColoredBlock {
    public static final int FOLIAGE_COLOR_INDEX = 0;
    public static final int FRUIT_COLOR_INDEX = 2;

    public BlockAbstractLeaves(AbstractBlock.Properties properties) {
        super(properties);
    }

    @Nullable
    protected abstract ITree getTree(IBlockReader var1, BlockPos var2);

    public final void func_149666_a(ItemGroup tab, NonNullList<ItemStack> list) {
    }

    public String func_149739_a() {
        return "block.forestry.leaves";
    }

    public ItemStack getPickBlock(BlockState state, RayTraceResult target, IBlockReader world, BlockPos pos, PlayerEntity player) {
        ITree tree = this.getTree(world, pos);
        if (tree == null) {
            return ItemStack.field_190927_a;
        }
        IAlleleTreeSpecies species = tree.getGenome().getActiveAllele(TreeChromosomes.SPECIES);
        return species.getDecorativeLeaves();
    }

    @Nonnull
    public List<ItemStack> onSheared(@Nullable PlayerEntity player, @Nonnull ItemStack item, World world, BlockPos pos, int fortune) {
        IAlleleTreeSpecies species;
        ItemStack decorativeLeaves;
        ITree tree = this.getTree((IBlockReader)world, pos);
        if (tree == null) {
            tree = TreeDefinition.Oak.createIndividual();
        }
        if ((decorativeLeaves = (species = tree.getGenome().getActiveAllele(TreeChromosomes.SPECIES)).getDecorativeLeaves()).func_190926_b()) {
            return Collections.emptyList();
        }
        return Collections.singletonList(decorativeLeaves);
    }

    public VoxelShape func_220071_b(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        ITree tree = this.getTree(worldIn, pos);
        if (tree != null && TreeDefinition.Willow.getUID().equals(tree.getIdentifier())) {
            return VoxelShapes.func_197880_a();
        }
        return super.func_220071_b(state, worldIn, pos, context);
    }

    public void func_196262_a(BlockState state, World worldIn, BlockPos pos, Entity entityIn) {
        super.func_196262_a(state, worldIn, pos, entityIn);
        Vector3d motion = entityIn.func_213322_ci();
        entityIn.func_213293_j(motion.func_82615_a() * 0.4, motion.func_82617_b(), motion.func_82616_c() * 0.4);
    }

    public final int getFlammability(BlockState state, IBlockReader world, BlockPos pos, Direction face) {
        return 60;
    }

    public final boolean isFlammable(BlockState state, IBlockReader world, BlockPos pos, Direction face) {
        return true;
    }

    public final int getFireSpreadSpeed(BlockState state, IBlockReader world, BlockPos pos, Direction face) {
        if (face == Direction.DOWN) {
            return 20;
        }
        if (face != Direction.UP) {
            return 10;
        }
        return 5;
    }

    public List<ItemStack> func_220076_a(BlockState state, LootContext.Builder builder) {
        return super.func_220076_a(state, builder);
    }

    protected abstract void getLeafDrop(NonNullList<ItemStack> var1, World var2, @Nullable GameProfile var3, BlockPos var4, float var5, int var6, LootContext.Builder var7);
}

