/*
 * Decompiled with CFR 0.152.
 */
package forestry.arboriculture.blocks;

import forestry.api.arboriculture.IFruitProvider;
import forestry.api.arboriculture.ILeafSpriteProvider;
import forestry.api.arboriculture.genetics.TreeChromosomes;
import forestry.arboriculture.genetics.TreeDefinition;
import forestry.core.blocks.IColoredBlock;
import forestry.core.proxy.Proxies;
import forestry.core.utils.BlockUtil;
import genetics.api.individual.IGenome;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.IForgeShearable;

public class BlockDecorativeLeaves
extends Block
implements IColoredBlock,
IForgeShearable {
    private TreeDefinition definition;

    public BlockDecorativeLeaves(TreeDefinition definition) {
        super(AbstractBlock.Properties.func_200945_a((Material)Material.field_151584_j).func_200943_b(0.2f).func_200947_a(SoundType.field_185850_c).func_226896_b_().func_235842_b_(BlockUtil::alwaysTrue).func_235828_a_((state, reader, pos) -> !Proxies.render.fancyGraphicsEnabled() && !TreeDefinition.Willow.equals(definition)));
        this.definition = definition;
    }

    public TreeDefinition getDefinition() {
        return this.definition;
    }

    public VoxelShape func_220071_b(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        if (TreeDefinition.Willow.equals(this.definition)) {
            return VoxelShapes.func_197880_a();
        }
        return super.func_220071_b(state, worldIn, pos, context);
    }

    public void func_196262_a(BlockState state, World worldIn, BlockPos pos, Entity entityIn) {
        super.func_196262_a(state, worldIn, pos, entityIn);
        Vector3d motion = entityIn.func_213322_ci();
        entityIn.func_213317_d(motion.func_216372_d(0.4, 1.0, 0.4));
    }

    public int getFlammability(BlockState state, IBlockReader world, BlockPos pos, Direction face) {
        return 60;
    }

    public boolean isFlammable(BlockState state, IBlockReader world, BlockPos pos, Direction face) {
        return true;
    }

    public int getFireSpreadSpeed(BlockState state, IBlockReader world, BlockPos pos, Direction face) {
        if (face == Direction.DOWN) {
            return 20;
        }
        if (face != Direction.UP) {
            return 10;
        }
        return 5;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public int colorMultiplier(BlockState state, @Nullable IBlockReader worldIn, @Nullable BlockPos pos, int tintIndex) {
        IGenome genome = this.definition.getGenome();
        if (tintIndex == 2) {
            IFruitProvider fruitProvider = genome.getActiveAllele(TreeChromosomes.FRUITS).getProvider();
            return fruitProvider.getDecorativeColor();
        }
        ILeafSpriteProvider spriteProvider = genome.getActiveAllele(TreeChromosomes.SPECIES).getLeafSpriteProvider();
        return spriteProvider.getColor(false);
    }
}

