/*
 * Decompiled with CFR 0.152.
 */
package forestry.arboriculture.blocks;

import com.mojang.authlib.GameProfile;
import forestry.api.arboriculture.ILeafSpriteProvider;
import forestry.api.arboriculture.TreeManager;
import forestry.api.arboriculture.genetics.EnumGermlingType;
import forestry.api.arboriculture.genetics.ITree;
import forestry.api.arboriculture.genetics.TreeChromosomes;
import forestry.arboriculture.blocks.BlockAbstractLeaves;
import forestry.arboriculture.genetics.TreeDefinition;
import genetics.api.individual.IGenome;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.BlockState;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.item.ItemStack;
import net.minecraft.loot.LootContext;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class BlockDefaultLeaves
extends BlockAbstractLeaves {
    private final TreeDefinition definition;

    public BlockDefaultLeaves(TreeDefinition definition) {
        super(AbstractBlock.Properties.func_200945_a((Material)Material.field_151584_j).func_200943_b(0.2f).func_200947_a(SoundType.field_185850_c).func_200944_c().func_226896_b_());
        this.definition = definition;
    }

    @Nullable
    public TreeDefinition getTreeDefinition(BlockState blockState) {
        if (blockState.func_177230_c() == this) {
            return this.definition;
        }
        return null;
    }

    public TreeDefinition getTreeDefinition() {
        return this.definition;
    }

    @Override
    protected void getLeafDrop(NonNullList<ItemStack> drops, World world, @Nullable GameProfile playerProfile, BlockPos pos, float saplingModifier, int fortune, LootContext.Builder builder) {
        ITree tree = this.getTree((IBlockReader)world, pos);
        if (tree == null) {
            return;
        }
        List<ITree> saplings = tree.getSaplings(world, playerProfile, pos, saplingModifier);
        for (ITree sapling : saplings) {
            if (sapling == null) continue;
            drops.add((Object)TreeManager.treeRoot.getTypes().createStack(sapling, EnumGermlingType.SAPLING));
        }
    }

    @Override
    protected ITree getTree(IBlockReader world, BlockPos pos) {
        BlockState blockState = world.func_180495_p(pos);
        TreeDefinition treeDefinition = this.getTreeDefinition(blockState);
        if (treeDefinition != null) {
            return treeDefinition.createIndividual();
        }
        return null;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public int colorMultiplier(BlockState state, @Nullable IBlockReader worldIn, @Nullable BlockPos pos, int tintIndex) {
        TreeDefinition treeDefinition = this.getTreeDefinition(state);
        if (treeDefinition == null) {
            treeDefinition = TreeDefinition.Oak;
        }
        IGenome genome = treeDefinition.getGenome();
        ILeafSpriteProvider spriteProvider = genome.getActiveAllele(TreeChromosomes.SPECIES).getLeafSpriteProvider();
        return spriteProvider.getColor(false);
    }
}

