/*
 * Decompiled with CFR 0.152.
 */
package forestry.arboriculture.blocks;

import com.mojang.authlib.GameProfile;
import forestry.api.arboriculture.IFruitProvider;
import forestry.api.arboriculture.ILeafSpriteProvider;
import forestry.api.arboriculture.TreeManager;
import forestry.api.arboriculture.genetics.EnumGermlingType;
import forestry.api.arboriculture.genetics.ITree;
import forestry.api.arboriculture.genetics.TreeChromosomes;
import forestry.arboriculture.blocks.BlockAbstractLeaves;
import forestry.arboriculture.features.ArboricultureBlocks;
import forestry.arboriculture.genetics.TreeDefinition;
import forestry.core.network.packets.PacketFXSignal;
import forestry.core.utils.NetworkUtil;
import forestry.modules.features.FeatureBlock;
import genetics.api.individual.IGenome;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.BlockState;
import net.minecraft.block.LeavesBlock;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.loot.LootContext;
import net.minecraft.state.Property;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.items.ItemHandlerHelper;

public class BlockDefaultLeavesFruit
extends BlockAbstractLeaves {
    private final TreeDefinition definition;

    public BlockDefaultLeavesFruit(TreeDefinition definition) {
        super(AbstractBlock.Properties.func_200945_a((Material)Material.field_151584_j).func_200943_b(0.2f).func_200947_a(SoundType.field_185850_c).func_200944_c().func_226896_b_());
        this.definition = definition;
    }

    public ActionResultType func_225533_a_(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult traceResult) {
        ItemStack mainHand = player.func_184586_b(Hand.MAIN_HAND);
        ItemStack offHand = player.func_184586_b(Hand.OFF_HAND);
        if (mainHand.func_190926_b() && offHand.func_190926_b()) {
            PacketFXSignal packet = new PacketFXSignal(PacketFXSignal.VisualFXType.BLOCK_BREAK, PacketFXSignal.SoundFXType.BLOCK_BREAK, pos, state);
            NetworkUtil.sendNetworkPacket(packet, pos, world);
            ITree tree = this.getTree((IBlockReader)world, pos);
            if (tree == null) {
                return ActionResultType.FAIL;
            }
            IFruitProvider fruitProvider = tree.getGenome().getActiveAllele(TreeChromosomes.FRUITS).getProvider();
            NonNullList<ItemStack> products = tree.produceStacks(world, pos, fruitProvider.getRipeningPeriod());
            world.func_180501_a(pos, (BlockState)((BlockState)((FeatureBlock)ArboricultureBlocks.LEAVES_DEFAULT.get(this.definition)).defaultState().func_206870_a((Property)LeavesBlock.field_208495_b, state.func_177229_b((Property)LeavesBlock.field_208495_b))).func_206870_a((Property)LeavesBlock.field_208494_a, state.func_177229_b((Property)LeavesBlock.field_208494_a)), 2);
            for (ItemStack fruit : products) {
                ItemHandlerHelper.giveItemToPlayer((PlayerEntity)player, (ItemStack)fruit);
            }
            return ActionResultType.SUCCESS;
        }
        return ActionResultType.PASS;
    }

    @Override
    protected void getLeafDrop(NonNullList<ItemStack> drops, World world, @Nullable GameProfile playerProfile, BlockPos pos, float saplingModifier, int fortune, LootContext.Builder builder) {
        ITree tree = this.getTree((IBlockReader)world, pos);
        if (tree == null) {
            return;
        }
        List<ITree> saplings = tree.getSaplings(world, playerProfile, pos, saplingModifier);
        for (ITree sapling : saplings) {
            if (sapling == null) continue;
            drops.add((Object)TreeManager.treeRoot.getTypes().createStack(sapling, EnumGermlingType.SAPLING));
        }
        IGenome genome = tree.getGenome();
        IFruitProvider fruitProvider = genome.getActiveAllele(TreeChromosomes.FRUITS).getProvider();
        if (fruitProvider.isFruitLeaf(genome, (IWorld)world, pos)) {
            NonNullList<ItemStack> produceStacks = tree.produceStacks(world, pos, Integer.MAX_VALUE);
            drops.addAll(produceStacks);
        }
    }

    public TreeDefinition getDefinition() {
        return this.definition;
    }

    @Override
    protected ITree getTree(IBlockReader world, BlockPos pos) {
        return this.definition.createIndividual();
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public int colorMultiplier(BlockState state, @Nullable IBlockReader worldIn, @Nullable BlockPos pos, int tintIndex) {
        IGenome genome = this.definition.getGenome();
        if (tintIndex == 2) {
            IFruitProvider fruitProvider = genome.getActiveAllele(TreeChromosomes.FRUITS).getProvider();
            return fruitProvider.getDecorativeColor();
        }
        ILeafSpriteProvider spriteProvider = genome.getActiveAllele(TreeChromosomes.SPECIES).getLeafSpriteProvider();
        return spriteProvider.getColor(false);
    }
}

