/*
 * Decompiled with CFR 0.152.
 */
package forestry.arboriculture.blocks;

import com.mojang.authlib.GameProfile;
import forestry.api.arboriculture.TreeManager;
import forestry.api.arboriculture.genetics.EnumGermlingType;
import forestry.api.arboriculture.genetics.ITree;
import forestry.api.core.IToolScoop;
import forestry.api.lepidopterology.ButterflyManager;
import forestry.api.lepidopterology.genetics.EnumFlutterType;
import forestry.api.lepidopterology.genetics.IButterfly;
import forestry.arboriculture.ModuleArboriculture;
import forestry.arboriculture.blocks.BlockAbstractLeaves;
import forestry.arboriculture.tiles.TileLeaves;
import forestry.core.network.packets.PacketFXSignal;
import forestry.core.tiles.TileUtil;
import forestry.core.utils.ItemStackUtil;
import forestry.core.utils.NetworkUtil;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.BlockState;
import net.minecraft.block.IGrowable;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.loot.LootContext;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.items.ItemHandlerHelper;

public class BlockForestryLeaves
extends BlockAbstractLeaves
implements IGrowable {
    public BlockForestryLeaves() {
        super(AbstractBlock.Properties.func_200945_a((Material)Material.field_151584_j).func_200943_b(0.2f).func_200947_a(SoundType.field_185850_c).func_200944_c().func_226896_b_());
    }

    @Override
    protected ITree getTree(IBlockReader world, BlockPos pos) {
        TileLeaves leaves = TileUtil.getTile(world, pos, TileLeaves.class);
        if (leaves != null) {
            ITree tree = leaves.getTree();
            return tree;
        }
        return null;
    }

    public void func_225534_a_(BlockState state, ServerWorld world, BlockPos pos, Random rand) {
        super.func_225534_a_(state, world, pos, rand);
        TileLeaves tileLeaves = TileUtil.getTile((IBlockReader)world, pos, TileLeaves.class);
        if (tileLeaves != null && !tileLeaves.func_145837_r() && (double)rand.nextFloat() <= 0.1) {
            tileLeaves.onBlockTick((World)world, pos, state, rand);
        }
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return new TileLeaves();
    }

    @Override
    protected void getLeafDrop(NonNullList<ItemStack> drops, World world, @Nullable GameProfile playerProfile, BlockPos pos, float saplingModifier, int fortune, LootContext.Builder builder) {
        TileLeaves tile = TileUtil.getTile(builder, TileLeaves.class);
        if (tile == null) {
            return;
        }
        ITree tree = tile.getTree();
        if (tree == null) {
            return;
        }
        List<ITree> saplings = tree.getSaplings(world, playerProfile, pos, saplingModifier);
        for (ITree sapling : saplings) {
            if (sapling == null) continue;
            drops.add((Object)TreeManager.treeRoot.getTypes().createStack(sapling, EnumGermlingType.SAPLING));
        }
        if (tile.hasFruit()) {
            drops.addAll(tree.produceStacks(world, pos, tile.getRipeningTime()));
        }
    }

    public ActionResultType func_225533_a_(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult hit) {
        TileLeaves leaves = TileUtil.getTile((IBlockReader)world, pos, TileLeaves.class);
        if (leaves != null) {
            IButterfly caterpillar = leaves.getCaterpillar();
            ItemStack heldItem = player.func_184586_b(hand);
            ItemStack otherHand = player.func_184586_b(hand == Hand.MAIN_HAND ? Hand.OFF_HAND : Hand.MAIN_HAND);
            if (heldItem.func_190926_b() && otherHand.func_190926_b()) {
                if (leaves.hasFruit() && leaves.getRipeness() >= 0.9f) {
                    PacketFXSignal packet = new PacketFXSignal(PacketFXSignal.VisualFXType.BLOCK_BREAK, PacketFXSignal.SoundFXType.BLOCK_BREAK, pos, state);
                    NetworkUtil.sendNetworkPacket(packet, pos, world);
                    for (ItemStack fruit : leaves.pickFruit(ItemStack.field_190927_a)) {
                        ItemHandlerHelper.giveItemToPlayer((PlayerEntity)player, (ItemStack)fruit);
                    }
                    return ActionResultType.SUCCESS;
                }
            } else if (heldItem.func_77973_b() instanceof IToolScoop && caterpillar != null) {
                ItemStack butterfly = ButterflyManager.butterflyRoot.getTypes().createStack(caterpillar, EnumFlutterType.CATERPILLAR);
                ItemStackUtil.dropItemStackAsEntity(butterfly, world, pos);
                leaves.setCaterpillar(null);
                return ActionResultType.SUCCESS;
            }
        }
        return ActionResultType.PASS;
    }

    public boolean func_176473_a(IBlockReader world, BlockPos pos, BlockState state, boolean isClient) {
        TileLeaves leafTile = TileUtil.getTile(world, pos, TileLeaves.class);
        return leafTile != null && leafTile.hasFruit() && leafTile.getRipeness() < 1.0f;
    }

    public boolean func_180670_a(World worldIn, Random rand, BlockPos pos, BlockState state) {
        return true;
    }

    public void func_225535_a_(ServerWorld world, Random rand, BlockPos pos, BlockState state) {
        TileLeaves leafTile = TileUtil.getTile((IBlockReader)world, pos, TileLeaves.class);
        if (leafTile != null) {
            leafTile.addRipeness(0.5f);
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public int colorMultiplier(BlockState state, @Nullable IBlockReader worldIn, @Nullable BlockPos pos, int tintIndex) {
        TileLeaves leaves;
        if (worldIn != null && pos != null && (leaves = TileUtil.getTile(worldIn, pos, TileLeaves.class)) != null) {
            if (tintIndex == 2) {
                return leaves.getFruitColour();
            }
            ClientPlayerEntity thePlayer = Minecraft.func_71410_x().field_71439_g;
            return leaves.getFoliageColour((PlayerEntity)thePlayer);
        }
        return ModuleArboriculture.proxy.getFoliageColorDefault();
    }
}

