/*
 * Decompiled with CFR 0.152.
 */
package forestry.arboriculture.blocks;

import forestry.api.arboriculture.IWoodType;
import forestry.api.arboriculture.WoodBlockKind;
import forestry.arboriculture.IWoodTyped;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraftforge.common.ToolType;

public class BlockForestryPlank
extends Block
implements IWoodTyped {
    private final boolean fireproof;
    private final IWoodType woodType;

    public static AbstractBlock.Properties createWoodProperties(IWoodType woodType) {
        return AbstractBlock.Properties.func_200945_a((Material)Material.field_151575_d).func_200948_a(woodType.getHardness(), woodType.getHardness() * 1.5f).func_200947_a(SoundType.field_185848_a).harvestTool(ToolType.AXE).harvestLevel(0);
    }

    public BlockForestryPlank(boolean fireproof, IWoodType woodType) {
        super(BlockForestryPlank.createWoodProperties(woodType));
        this.fireproof = fireproof;
        this.woodType = woodType;
    }

    @Override
    public IWoodType getWoodType() {
        return this.woodType;
    }

    @Override
    public boolean isFireproof() {
        return this.fireproof;
    }

    @Override
    public WoodBlockKind getBlockKind() {
        return WoodBlockKind.PLANKS;
    }

    public int getFlammability(BlockState state, IBlockReader world, BlockPos pos, Direction face) {
        if (this.fireproof) {
            return 0;
        }
        return 20;
    }

    public int getFireSpreadSpeed(BlockState state, IBlockReader world, BlockPos pos, Direction face) {
        if (this.fireproof) {
            return 0;
        }
        return 5;
    }
}

