/*
 * Decompiled with CFR 0.152.
 */
package forestry.arboriculture.blocks;

import forestry.api.arboriculture.TreeManager;
import forestry.api.arboriculture.genetics.EnumGermlingType;
import forestry.api.arboriculture.genetics.ITree;
import forestry.arboriculture.blocks.BlockTreeContainer;
import forestry.arboriculture.tiles.TileSapling;
import forestry.core.tiles.TileUtil;
import forestry.core.utils.ItemStackUtil;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.IGrowable;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.FluidState;
import net.minecraft.item.ItemStack;
import net.minecraft.loot.LootContext;
import net.minecraft.loot.LootParameters;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;

public class BlockSapling
extends BlockTreeContainer
implements IGrowable {
    protected static final VoxelShape SHAPE = Block.func_208617_a((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)12.0, (double)14.0);

    public BlockSapling() {
        super(AbstractBlock.Properties.func_200945_a((Material)Material.field_151585_k).func_200942_a().func_200943_b(0.0f).func_200947_a(SoundType.field_185850_c));
    }

    public VoxelShape func_220053_a(BlockState blockState, IBlockReader blockReader, BlockPos pos, ISelectionContext context) {
        return SHAPE;
    }

    @Nullable
    public TileEntity func_196283_a_(IBlockReader worldIn) {
        return new TileSapling();
    }

    public static boolean canBlockStay(IBlockReader world, BlockPos pos) {
        TileSapling tile = TileUtil.getTile(world, pos, TileSapling.class);
        if (tile == null) {
            return false;
        }
        ITree tree = tile.getTree();
        return tree != null && tree.canStay(world, pos);
    }

    public void func_220069_a(BlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos, boolean p_220069_6_) {
        super.func_220069_a(state, worldIn, pos, blockIn, fromPos, p_220069_6_);
        if (!worldIn.field_72995_K && !BlockSapling.canBlockStay((IBlockReader)worldIn, pos)) {
            BlockSapling.dropAsSapling(worldIn, pos);
            worldIn.func_175656_a(pos, Blocks.field_150350_a.func_176223_P());
        }
    }

    public List<ItemStack> func_220076_a(BlockState blockState, LootContext.Builder builder) {
        ItemStack drop = BlockSapling.getDrop((IBlockReader)builder.func_216018_a(), new BlockPos((Vector3d)builder.func_216024_a(LootParameters.field_237457_g_)));
        if (!drop.func_190926_b()) {
            return Collections.singletonList(drop);
        }
        return Collections.emptyList();
    }

    public ItemStack getPickBlock(BlockState state, RayTraceResult target, IBlockReader world, BlockPos pos, PlayerEntity player) {
        TileSapling sapling = TileUtil.getTile(world, pos, TileSapling.class);
        if (sapling == null || sapling.getTree() == null) {
            return ItemStack.field_190927_a;
        }
        return TreeManager.treeRoot.getTypes().createStack(sapling.getTree(), EnumGermlingType.SAPLING);
    }

    public boolean removedByPlayer(BlockState state, World world, BlockPos pos, PlayerEntity player, boolean willHarvest, FluidState fluid) {
        if (!world.field_72995_K && this.canHarvestBlock(state, (IBlockReader)world, pos, player) && !player.func_184812_l_()) {
            BlockSapling.dropAsSapling(world, pos);
        }
        this.getBlock().func_176208_a(world, pos, state, player);
        return world.func_180501_a(pos, Blocks.field_150350_a.func_176223_P(), 1);
    }

    private static void dropAsSapling(World world, BlockPos pos) {
        if (world.field_72995_K) {
            return;
        }
        ItemStack drop = BlockSapling.getDrop((IBlockReader)world, pos);
        if (!drop.func_190926_b()) {
            ItemStackUtil.dropItemStackAsEntity(drop, world, pos);
        }
    }

    private static ItemStack getDrop(IBlockReader world, BlockPos pos) {
        ITree tree;
        TileSapling sapling = TileUtil.getTile(world, pos, TileSapling.class);
        if (sapling != null && (tree = sapling.getTree()) != null) {
            return TreeManager.treeRoot.getTypes().createStack(tree, EnumGermlingType.SAPLING);
        }
        return ItemStack.field_190927_a;
    }

    public boolean func_176473_a(IBlockReader world, BlockPos pos, BlockState state, boolean isClient) {
        return true;
    }

    public boolean func_180670_a(World world, Random rand, BlockPos pos, BlockState state) {
        if (world.field_73012_v.nextFloat() >= 0.45f) {
            return false;
        }
        TileSapling saplingTile = TileUtil.getTile((IBlockReader)world, pos, TileSapling.class);
        return saplingTile == null || saplingTile.canAcceptBoneMeal(rand);
    }

    public void func_225535_a_(ServerWorld world, Random rand, BlockPos pos, BlockState blockState) {
        TileSapling saplingTile = TileUtil.getTile((IBlockReader)world, pos, TileSapling.class);
        if (saplingTile != null) {
            saplingTile.tryGrow(rand, true);
        }
    }
}

