/*
 * Decompiled with CFR 0.152.
 */
package forestry.arboriculture.charcoal.jei;

import com.mojang.blaze3d.matrix.MatrixStack;
import forestry.arboriculture.charcoal.jei.CharcoalJeiPlugin;
import forestry.arboriculture.charcoal.jei.CharcoalPileWallWrapper;
import forestry.arboriculture.features.CharcoalBlocks;
import forestry.core.recipes.jei.ForestryRecipeCategory;
import forestry.core.recipes.jei.ForestryTooltipCallback;
import java.util.List;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.drawable.IDrawableAnimated;
import mezz.jei.api.gui.drawable.IDrawableStatic;
import mezz.jei.api.gui.ingredient.IGuiItemStackGroup;
import mezz.jei.api.gui.ingredient.ITooltipCallback;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredients;
import net.minecraft.util.ResourceLocation;

public class CharcoalPileWallCategory
extends ForestryRecipeCategory<CharcoalPileWallWrapper> {
    private final IDrawableStatic slot;
    private final IDrawableStatic arrow;
    private final IDrawableAnimated arrowAnimated;
    private final IDrawableStatic flame;
    private final IDrawableAnimated flameAnimated;
    private final IDrawable icon;

    public CharcoalPileWallCategory(IGuiHelper helper) {
        super((IDrawable)helper.createBlankDrawable(120, 38), "for.jei.charcoal.pile");
        ResourceLocation resourceLocation = new ResourceLocation("forestry", "textures/gui/jei/recipes.png");
        this.arrow = helper.createDrawable(resourceLocation, 0, 14, 22, 16);
        IDrawableStatic arrowAnimated = helper.createDrawable(resourceLocation, 22, 14, 22, 16);
        this.arrowAnimated = helper.createAnimatedDrawable(arrowAnimated, 160, IDrawableAnimated.StartDirection.LEFT, false);
        this.flame = helper.createDrawable(resourceLocation, 0, 0, 14, 14);
        IDrawableStatic flameAnimated = helper.createDrawable(resourceLocation, 14, 0, 14, 14);
        this.flameAnimated = helper.createAnimatedDrawable(flameAnimated, 260, IDrawableAnimated.StartDirection.TOP, true);
        this.slot = helper.getSlotDrawable();
        this.icon = helper.createDrawableIngredient((Object)CharcoalBlocks.WOOD_PILE.stack());
    }

    public ResourceLocation getUid() {
        return CharcoalJeiPlugin.RECIPE_UID;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public Class<? extends CharcoalPileWallWrapper> getRecipeClass() {
        return CharcoalPileWallWrapper.class;
    }

    public void draw(CharcoalPileWallWrapper recipe, MatrixStack matrixStack, double mouseX, double mouseY) {
        this.flame.draw(matrixStack, 52, 0);
        this.flameAnimated.draw(matrixStack, 52, 0);
        this.arrow.draw(matrixStack, 50, 16);
        this.arrowAnimated.draw(matrixStack, 50, 16);
        this.slot.draw(matrixStack, 0, 16);
        this.slot.draw(matrixStack, 20, 16);
        this.slot.draw(matrixStack, 84, 16);
        this.slot.draw(matrixStack, 104, 16);
    }

    public void setRecipe(IRecipeLayout recipeLayout, CharcoalPileWallWrapper recipeWrapper, IIngredients ingredients) {
        IGuiItemStackGroup itemStackGroup = recipeLayout.getItemStacks();
        itemStackGroup.init(0, true, 0, 16);
        itemStackGroup.init(1, true, 20, 16);
        itemStackGroup.init(2, false, 84, 16);
        itemStackGroup.init(3, false, 104, 16);
        itemStackGroup.set(0, (List)ingredients.getInputs(VanillaTypes.ITEM).get(0));
        itemStackGroup.set(1, CharcoalBlocks.WOOD_PILE.stack());
        itemStackGroup.set(2, (List)ingredients.getOutputs(VanillaTypes.ITEM).get(0));
        itemStackGroup.set(3, (List)ingredients.getOutputs(VanillaTypes.ITEM).get(1));
        ForestryTooltipCallback tooltip = new ForestryTooltipCallback();
        tooltip.addFortuneTooltip(2);
        tooltip.addFortuneTooltip(3);
        itemStackGroup.addTooltipCallback((ITooltipCallback)tooltip);
    }
}

