/*
 * Decompiled with CFR 0.152.
 */
package forestry.arboriculture.compat;

import forestry.arboriculture.features.ArboricultureItems;
import forestry.core.utils.JeiUtil;
import forestry.modules.ModuleHelper;
import genetics.api.GeneticHelper;
import java.util.Optional;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.ingredients.subtypes.ISubtypeInterpreter;
import mezz.jei.api.registration.IRecipeRegistration;
import mezz.jei.api.registration.ISubtypeRegistration;
import net.minecraft.item.Item;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
@JeiPlugin
public class ArboricultureJeiPlugin
implements IModPlugin {
    public ResourceLocation getPluginUid() {
        return new ResourceLocation("forestry");
    }

    public void registerItemSubtypes(ISubtypeRegistration subtypeRegistry) {
        if (!ModuleHelper.isEnabled("arboriculture")) {
            return;
        }
        ISubtypeInterpreter arboSubtypeInterpreter = itemStack -> {
            Optional individual = GeneticHelper.getIndividual(itemStack);
            return individual.map(iIndividual -> iIndividual.getGenome().getPrimary().getBinomial()).orElse("");
        };
        subtypeRegistry.registerSubtypeInterpreter(ArboricultureItems.SAPLING.item(), arboSubtypeInterpreter);
        subtypeRegistry.registerSubtypeInterpreter(ArboricultureItems.POLLEN_FERTILE.item(), arboSubtypeInterpreter);
    }

    public void registerRecipes(IRecipeRegistration registration) {
        if (!ModuleHelper.isEnabled("arboriculture")) {
            return;
        }
        JeiUtil.addDescription(registration, new Item[]{ArboricultureItems.GRAFTER.item(), ArboricultureItems.GRAFTER_PROVEN.item()});
    }
}

