/*
 * Decompiled with CFR 0.152.
 */
package forestry.arboriculture.genetics;

import forestry.api.arboriculture.genetics.ITree;
import forestry.api.arboriculture.genetics.TreeChromosomes;
import forestry.api.genetics.ICheckPollinatable;
import forestry.apiculture.ModuleApiculture;
import genetics.api.individual.IIndividual;
import net.minecraftforge.common.PlantType;

public class CheckPollinatableTree
implements ICheckPollinatable {
    private final ITree tree;

    public CheckPollinatableTree(ITree tree) {
        this.tree = tree;
    }

    @Override
    public PlantType getPlantType() {
        return this.tree.getGenome().getActiveAllele(TreeChromosomes.SPECIES).getPlantType();
    }

    @Override
    public ITree getPollen() {
        return this.tree;
    }

    @Override
    public boolean canMateWith(IIndividual pollen) {
        return pollen instanceof ITree && !this.isPollinated() && (ModuleApiculture.doSelfPollination || !this.tree.isGeneticEqual(pollen));
    }

    @Override
    public boolean isPollinated() {
        return this.tree.getMate().isPresent();
    }
}

