/*
 * Decompiled with CFR 0.152.
 */
package forestry.arboriculture.genetics;

import forestry.arboriculture.genetics.BranchTrees;
import forestry.arboriculture.genetics.TreeHelper;
import genetics.api.alleles.IAlleleTemplate;
import genetics.api.classification.IBranchDefinition;
import genetics.api.classification.IClassification;
import genetics.api.classification.IClassificationRegistry;
import java.util.Locale;
import org.apache.commons.lang3.text.WordUtils;

public enum TreeBranchDefinition implements IBranchDefinition
{
    ACACIA,
    ACER,
    ADANSONIA,
    ASTRONIUM,
    BETULA,
    CASTANEA,
    CEIBA,
    CHLOROCARDIUM,
    CITRUS,
    DALBERGIA,
    EBONY("Diospyros"),
    JUGLANS,
    LARIX,
    MAHOGANY("Shorea"),
    MILLETTIA,
    OCHROMA,
    PHOENIX,
    PICEA,
    PINUS,
    POPULUS,
    PRUNUS,
    PTEROCARPUS,
    QUERCUS,
    SALIX,
    SEQUOIA,
    SEQUOIADENDRON,
    TABEBUIA,
    TALIPARITI,
    TECTONA,
    TILIA,
    CARICA,
    TROPICAL("");

    private final IClassification branch;

    private TreeBranchDefinition() {
        String name = this.name().toLowerCase(Locale.ENGLISH);
        String scientific = WordUtils.capitalize((String)name);
        this.branch = new BranchTrees(name, scientific);
    }

    private TreeBranchDefinition(String scientific) {
        String name = this.name().toLowerCase(Locale.ENGLISH);
        this.branch = new BranchTrees(name, scientific);
    }

    @Override
    public IAlleleTemplate getTemplate() {
        return TreeHelper.getKaryotype().getDefaultTemplate();
    }

    @Override
    public IClassification getBranch() {
        return this.branch;
    }

    public static void registerBranches(IClassificationRegistry classRegistry) {
        IClassification plantae = classRegistry.getClassification("kingdom.plantae");
        plantae.addMemberGroup(classRegistry.createAndRegisterClassification(IClassification.EnumClassLevel.DIVISION, "angiosperms", "Angiosperms", classRegistry.createAndRegisterClassification(IClassification.EnumClassLevel.CLASS, "asterids", "Asterids", classRegistry.createAndRegisterClassification(IClassification.EnumClassLevel.ORDER, "ericales", "Ericales", classRegistry.createAndRegisterClassification(IClassification.EnumClassLevel.FAMILY, "ebenaceae", "Ebenaceae", EBONY.getBranch()), classRegistry.createAndRegisterClassification(IClassification.EnumClassLevel.FAMILY, "fabaceae", "Fabaceae", ACACIA.getBranch(), DALBERGIA.getBranch(), MILLETTIA.getBranch(), PTEROCARPUS.getBranch())), classRegistry.createAndRegisterClassification(IClassification.EnumClassLevel.ORDER, "lamiales", "Lamiales", classRegistry.createAndRegisterClassification(IClassification.EnumClassLevel.FAMILY, "bignoniaceae", "Bignoniaceae", TABEBUIA.getBranch()), classRegistry.createAndRegisterClassification(IClassification.EnumClassLevel.FAMILY, "lamiaceae", "Lamiaceae", TECTONA.getBranch()))), classRegistry.createAndRegisterClassification(IClassification.EnumClassLevel.CLASS, "commelinids", "Commelinids", classRegistry.createAndRegisterClassification(IClassification.EnumClassLevel.ORDER, "arecales", "Arecales", classRegistry.createAndRegisterClassification(IClassification.EnumClassLevel.FAMILY, "arecaceae", "Arecaceae", PHOENIX.getBranch()))), classRegistry.createAndRegisterClassification(IClassification.EnumClassLevel.CLASS, "rosids", "Rosids", classRegistry.createAndRegisterClassification(IClassification.EnumClassLevel.ORDER, "brassicales", "Brassicales", classRegistry.createAndRegisterClassification(IClassification.EnumClassLevel.FAMILY, "caricaceae", "Caricaceae")), classRegistry.createAndRegisterClassification(IClassification.EnumClassLevel.ORDER, "fabales", "Fabales"), classRegistry.createAndRegisterClassification(IClassification.EnumClassLevel.ORDER, "fagales", "Fagales", classRegistry.createAndRegisterClassification(IClassification.EnumClassLevel.FAMILY, "betulaceae", "Betulaceae", BETULA.getBranch()), classRegistry.createAndRegisterClassification(IClassification.EnumClassLevel.FAMILY, "fagaceae", "Fagaceae", CASTANEA.getBranch(), QUERCUS.getBranch()), classRegistry.createAndRegisterClassification(IClassification.EnumClassLevel.FAMILY, "juglandaceae", "Juglandaceae", JUGLANS.getBranch())), classRegistry.createAndRegisterClassification(IClassification.EnumClassLevel.ORDER, "rosales", "Rosales", classRegistry.createAndRegisterClassification(IClassification.EnumClassLevel.FAMILY, "rosaceae", "Rosaceae", PRUNUS.getBranch())), classRegistry.createAndRegisterClassification(IClassification.EnumClassLevel.ORDER, "malvales", "Malvales", classRegistry.createAndRegisterClassification(IClassification.EnumClassLevel.FAMILY, "dipterocarpaceae", "Dipterocarpaceae", MAHOGANY.getBranch()), classRegistry.createAndRegisterClassification(IClassification.EnumClassLevel.FAMILY, "malvaceae", "Malvaceae", ADANSONIA.getBranch(), CEIBA.getBranch(), OCHROMA.getBranch(), TALIPARITI.getBranch(), TILIA.getBranch())), classRegistry.createAndRegisterClassification(IClassification.EnumClassLevel.ORDER, "laurales", "Laurales"), classRegistry.createAndRegisterClassification(IClassification.EnumClassLevel.ORDER, "malpighiales", "Malpighiales", classRegistry.createAndRegisterClassification(IClassification.EnumClassLevel.FAMILY, "salicaceae", "Salicaceae", CHLOROCARDIUM.getBranch(), POPULUS.getBranch(), SALIX.getBranch()), classRegistry.createAndRegisterClassification(IClassification.EnumClassLevel.FAMILY, "lauraceae", "Lauraceae")), classRegistry.createAndRegisterClassification(IClassification.EnumClassLevel.ORDER, "sapindales", "Sapindales", classRegistry.createAndRegisterClassification(IClassification.EnumClassLevel.FAMILY, "rutaceae", "Rutaceae", CITRUS.getBranch()), classRegistry.createAndRegisterClassification(IClassification.EnumClassLevel.FAMILY, "sapindaceae", "Sapindaceae", ACER.getBranch()), classRegistry.createAndRegisterClassification(IClassification.EnumClassLevel.FAMILY, "anacardiaceae", "Anacardiaceae", ASTRONIUM.getBranch())))));
        plantae.addMemberGroup(classRegistry.createAndRegisterClassification(IClassification.EnumClassLevel.DIVISION, "pinophyta", "Pinophyta", classRegistry.createAndRegisterClassification(IClassification.EnumClassLevel.CLASS, "pinopsida", "Pinopsida", classRegistry.createAndRegisterClassification(IClassification.EnumClassLevel.ORDER, "pinales", "Pinales", classRegistry.createAndRegisterClassification(IClassification.EnumClassLevel.FAMILY, "pinaceae", "Pinaceae", PICEA.getBranch(), PINUS.getBranch(), LARIX.getBranch()), classRegistry.createAndRegisterClassification(IClassification.EnumClassLevel.FAMILY, "cupressaceae", "Cupressaceae", SEQUOIA.getBranch(), SEQUOIADENDRON.getBranch()))), classRegistry.createAndRegisterClassification(IClassification.EnumClassLevel.CLASS, "magnoliopsida", "Magnoliopsida")));
        plantae.addMemberGroup(classRegistry.createAndRegisterClassification(IClassification.EnumClassLevel.DIVISION, "magnoliophyta", "Magnoliophyta"));
    }
}

