/*
 * Decompiled with CFR 0.152.
 */
package forestry.arboriculture.genetics.alleles;

import forestry.api.arboriculture.EnumFruitFamily;
import forestry.api.arboriculture.genetics.IAlleleFruit;
import forestry.api.arboriculture.genetics.TreeChromosomes;
import forestry.arboriculture.FruitProviderNone;
import forestry.arboriculture.FruitProviderPod;
import forestry.arboriculture.FruitProviderRipening;
import forestry.arboriculture.genetics.alleles.AlleleFruit;
import forestry.core.features.CoreItems;
import forestry.core.items.ItemFruit;
import genetics.api.alleles.IAlleleRegistry;
import genetics.utils.AlleleUtils;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.util.IItemProvider;

public class AlleleFruits {
    public static final IAlleleFruit fruitNone;
    public static final IAlleleFruit fruitApple;
    public static final IAlleleFruit fruitCocoa;
    public static final IAlleleFruit fruitChestnut;
    public static final IAlleleFruit fruitWalnut;
    public static final IAlleleFruit fruitCherry;
    public static final IAlleleFruit fruitDates;
    public static final IAlleleFruit fruitPapaya;
    public static final IAlleleFruit fruitLemon;
    public static final IAlleleFruit fruitPlum;
    private static final List<IAlleleFruit> fruitAlleles;
    @Nullable
    private static List<IAlleleFruit> fruitAllelesWithModels;

    public static void registerAlleles(IAlleleRegistry registry) {
        for (IAlleleFruit fruitAllele : fruitAlleles) {
            registry.registerAllele(fruitAllele, TreeChromosomes.FRUITS);
        }
    }

    public static List<IAlleleFruit> getFruitAlleles() {
        return fruitAlleles;
    }

    public static List<IAlleleFruit> getFruitAllelesWithModels() {
        if (fruitAllelesWithModels == null) {
            fruitAllelesWithModels = new ArrayList<IAlleleFruit>();
            AlleleUtils.filteredStream(TreeChromosomes.FRUITS).filter(allele -> allele.getModelName() != null).forEach(allele -> fruitAllelesWithModels.add((IAlleleFruit)allele));
        }
        return fruitAllelesWithModels;
    }

    static {
        ItemStack cocoaBean = new ItemStack((IItemProvider)Items.field_196130_bo);
        fruitNone = new AlleleFruit("none", new FruitProviderNone("for.fruits.none", EnumFruitFamily.NONE));
        fruitApple = new AlleleFruit("apple", new FruitProviderRipening("for.fruits.apple", EnumFruitFamily.POMES, () -> new ItemStack((IItemProvider)Items.field_151034_e), 1.0f).setColours(new Color(0xFF2E2E), new Color(14939292)).setOverlay("pomes"));
        fruitAlleles = Arrays.asList(fruitNone, fruitApple, fruitCocoa = new AlleleFruit("cocoa", new FruitProviderPod("for.fruits.cocoa", EnumFruitFamily.JUNGLE, FruitProviderPod.EnumPodType.COCOA, () -> cocoaBean)), fruitChestnut = new AlleleFruit("chestnut", new FruitProviderRipening("for.fruits.chestnut", EnumFruitFamily.NUX, () -> CoreItems.FRUITS.stack(ItemFruit.EnumFruit.CHESTNUT, 1), 1.0f).setRipeningPeriod(6).setColours(new Color(8336189), new Color(12898890)).setOverlay("nuts"), true), fruitWalnut = new AlleleFruit("walnut", new FruitProviderRipening("for.fruits.walnut", EnumFruitFamily.NUX, () -> CoreItems.FRUITS.stack(ItemFruit.EnumFruit.WALNUT, 1), 1.0f).setRipeningPeriod(8).setColours(new Color(16491080), new Color(12898890)).setOverlay("nuts"), true), fruitCherry = new AlleleFruit("cherry", new FruitProviderRipening("for.fruits.cherry", EnumFruitFamily.PRUNES, () -> CoreItems.FRUITS.stack(ItemFruit.EnumFruit.CHERRY, 1), 1.0f).setColours(new Color(0xFF2E2E), new Color(12898890)).setOverlay("berries"), true), fruitDates = new AlleleFruit("dates", new FruitProviderPod("for.fruits.dates", EnumFruitFamily.JUNGLE, FruitProviderPod.EnumPodType.DATES, () -> CoreItems.FRUITS.stack(ItemFruit.EnumFruit.DATES, 4))), fruitPapaya = new AlleleFruit("papaya", new FruitProviderPod("for.fruits.papaya", EnumFruitFamily.JUNGLE, FruitProviderPod.EnumPodType.PAPAYA, () -> CoreItems.FRUITS.stack(ItemFruit.EnumFruit.PAPAYA, 1))), fruitLemon = new AlleleFruit("lemon", new FruitProviderRipening("for.fruits.lemon", EnumFruitFamily.PRUNES, () -> CoreItems.FRUITS.stack(ItemFruit.EnumFruit.LEMON, 1), 1.0f).setColours(new Color(0xEEEE00), new Color(0x99FF00)).setOverlay("citrus"), true), fruitPlum = new AlleleFruit("plum", new FruitProviderRipening("for.fruits.plum", EnumFruitFamily.PRUNES, () -> CoreItems.FRUITS.stack(ItemFruit.EnumFruit.PLUM, 1), 1.0f).setColours(new Color(0x663446), new Color(15662874)).setOverlay("plums"), true));
    }
}

