/*
 * Decompiled with CFR 0.152.
 */
package forestry.arboriculture.items;

import forestry.api.arboriculture.TreeManager;
import forestry.api.arboriculture.genetics.EnumGermlingType;
import forestry.api.arboriculture.genetics.IAlleleTreeSpecies;
import forestry.api.arboriculture.genetics.ITree;
import forestry.api.arboriculture.genetics.TreeChromosomes;
import forestry.api.core.ItemGroups;
import forestry.api.genetics.ICheckPollinatable;
import forestry.api.genetics.IPollinatable;
import forestry.api.recipes.IVariableFermentable;
import forestry.arboriculture.genetics.TreeHelper;
import forestry.core.config.Config;
import forestry.core.genetics.ItemGE;
import forestry.core.items.definitions.IColoredItem;
import forestry.core.network.packets.PacketFXSignal;
import forestry.core.utils.GeneticsUtil;
import forestry.core.utils.NetworkUtil;
import genetics.api.GeneticHelper;
import genetics.api.organism.IOrganismType;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.ICapabilityProvider;

public class ItemGermlingGE
extends ItemGE
implements IVariableFermentable,
IColoredItem {
    private final EnumGermlingType type;

    public ItemGermlingGE(EnumGermlingType type) {
        super(new Item.Properties().func_200916_a(ItemGroups.tabArboriculture));
        this.type = type;
    }

    @Override
    protected final IOrganismType getType() {
        return this.type;
    }

    @Override
    protected IAlleleTreeSpecies getSpecies(ItemStack itemStack) {
        return GeneticHelper.getOrganism(itemStack).getAllele(TreeChromosomes.SPECIES, true);
    }

    @Nullable
    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable CompoundNBT nbt) {
        return GeneticHelper.createOrganism(stack, this.type, TreeHelper.getRoot().getDefinition());
    }

    public void func_150895_a(ItemGroup tab, NonNullList<ItemStack> subItems) {
        if (this.func_194125_a(tab)) {
            this.addCreativeItems(subItems, true);
        }
    }

    public void addCreativeItems(NonNullList<ItemStack> subItems, boolean hideSecrets) {
        for (ITree individual : TreeHelper.getRoot().getIndividualTemplates()) {
            if (hideSecrets && individual.isSecret() && !Config.isDebug) continue;
            ItemStack stack = new ItemStack((IItemProvider)this);
            GeneticHelper.setIndividual(stack, individual);
            subItems.add((Object)stack);
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public int getColorFromItemStack(ItemStack itemstack, int renderPass) {
        return this.getSpecies(itemstack).getGermlingColour(this.type, renderPass);
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, PlayerEntity playerIn, Hand handIn) {
        BlockRayTraceResult traceResult = ItemGermlingGE.func_219968_a((World)worldIn, (PlayerEntity)playerIn, (RayTraceContext.FluidMode)RayTraceContext.FluidMode.ANY);
        BlockItemUseContext context = new BlockItemUseContext(new ItemUseContext(playerIn, handIn, traceResult));
        ItemStack itemStack = playerIn.func_184586_b(handIn);
        if (traceResult.func_216346_c() == RayTraceResult.Type.BLOCK) {
            BlockPos pos = traceResult.func_216350_a();
            Optional treeOptional = TreeManager.treeRoot.create(itemStack);
            if (treeOptional.isPresent()) {
                ITree tree = (ITree)treeOptional.get();
                if (this.type == EnumGermlingType.SAPLING) {
                    return ItemGermlingGE.onItemRightClickSapling(itemStack, worldIn, playerIn, pos, tree, context);
                }
                if (this.type == EnumGermlingType.POLLEN) {
                    return ItemGermlingGE.onItemRightClickPollen(itemStack, worldIn, playerIn, pos, tree);
                }
            }
        }
        return new ActionResult(ActionResultType.PASS, (Object)itemStack);
    }

    private static ActionResult<ItemStack> onItemRightClickPollen(ItemStack itemStackIn, World worldIn, PlayerEntity player, BlockPos pos, ITree tree) {
        ICheckPollinatable checkPollinatable = GeneticsUtil.getCheckPollinatable(worldIn, pos);
        if (checkPollinatable == null || !checkPollinatable.canMateWith(tree)) {
            return new ActionResult(ActionResultType.FAIL, (Object)itemStackIn);
        }
        IPollinatable pollinatable = GeneticsUtil.getOrCreatePollinatable(player.func_146103_bH(), worldIn, pos, true);
        if (pollinatable == null || !pollinatable.canMateWith(tree)) {
            return new ActionResult(ActionResultType.FAIL, (Object)itemStackIn);
        }
        if (worldIn.field_72995_K) {
            return new ActionResult(ActionResultType.SUCCESS, (Object)itemStackIn);
        }
        pollinatable.mateWith(tree);
        BlockState blockState = worldIn.func_180495_p(pos);
        PacketFXSignal packet = new PacketFXSignal(PacketFXSignal.VisualFXType.BLOCK_BREAK, PacketFXSignal.SoundFXType.BLOCK_BREAK, pos, blockState);
        NetworkUtil.sendNetworkPacket(packet, pos, worldIn);
        if (!player.func_184812_l_()) {
            itemStackIn.func_190918_g(1);
        }
        return new ActionResult(ActionResultType.SUCCESS, (Object)itemStackIn);
    }

    private static ActionResult<ItemStack> onItemRightClickSapling(ItemStack itemStackIn, World worldIn, PlayerEntity player, BlockPos pos, ITree tree, BlockItemUseContext context) {
        BlockState hitBlock = worldIn.func_180495_p(pos);
        if (!hitBlock.func_196953_a(context)) {
            if (!worldIn.func_175623_d(pos.func_177984_a())) {
                return new ActionResult(ActionResultType.FAIL, (Object)itemStackIn);
            }
            pos = pos.func_177984_a();
        }
        if (tree.canStay((IBlockReader)worldIn, pos) && TreeManager.treeRoot.plantSapling(worldIn, tree, player.func_146103_bH(), pos)) {
            if (!player.func_184812_l_()) {
                itemStackIn.func_190918_g(1);
            }
            return new ActionResult(ActionResultType.SUCCESS, (Object)itemStackIn);
        }
        return new ActionResult(ActionResultType.FAIL, (Object)itemStackIn);
    }

    @Override
    public float getFermentationModifier(ItemStack itemstack) {
        itemstack = GeneticsUtil.convertToGeneticEquivalent(itemstack);
        Optional treeOptional = TreeManager.treeRoot.create(itemstack);
        return treeOptional.map(tree -> Float.valueOf(tree.getGenome().getActiveValue(TreeChromosomes.SAPPINESS).floatValue() * 10.0f)).orElse(Float.valueOf(1.0f)).floatValue();
    }

    @Override
    public int getBurnTime(ItemStack itemStack) {
        return 100;
    }
}

