/*
 * Decompiled with CFR 0.152.
 */
package forestry.arboriculture.models;

import com.google.common.base.Preconditions;
import forestry.api.arboriculture.ILeafSpriteProvider;
import forestry.api.arboriculture.genetics.IAlleleTreeSpecies;
import forestry.api.arboriculture.genetics.TreeChromosomes;
import forestry.arboriculture.blocks.BlockDecorativeLeaves;
import forestry.arboriculture.genetics.TreeDefinition;
import forestry.core.models.ModelBlockCached;
import forestry.core.models.baker.ModelBaker;
import forestry.core.proxy.Proxies;
import forestry.core.utils.ResourceUtil;
import genetics.api.individual.IGenome;
import java.util.Objects;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.model.data.IModelData;

@OnlyIn(value=Dist.CLIENT)
public class ModelDecorativeLeaves
extends ModelBlockCached<BlockDecorativeLeaves, Key> {
    public ModelDecorativeLeaves() {
        super(BlockDecorativeLeaves.class);
    }

    @Override
    protected Key getInventoryKey(ItemStack stack) {
        Block block = Block.func_149634_a((Item)stack.func_77973_b());
        Preconditions.checkArgument((boolean)(block instanceof BlockDecorativeLeaves), (Object)"ItemStack must be for decorative leaves.");
        BlockDecorativeLeaves bBlock = (BlockDecorativeLeaves)block;
        return new Key(bBlock.getDefinition(), Proxies.render.fancyGraphicsEnabled());
    }

    @Override
    protected Key getWorldKey(BlockState state, IModelData extraData) {
        Block block = state.func_177230_c();
        Preconditions.checkArgument((boolean)(block instanceof BlockDecorativeLeaves), (Object)"state must be for decorative leaves.");
        BlockDecorativeLeaves bBlock = (BlockDecorativeLeaves)block;
        return new Key(bBlock.getDefinition(), Proxies.render.fancyGraphicsEnabled());
    }

    @Override
    protected void bakeBlock(BlockDecorativeLeaves block, IModelData extraData, Key key, ModelBaker baker, boolean inventory) {
        TreeDefinition treeDefinition = key.definition;
        IGenome genome = treeDefinition.getGenome();
        IAlleleTreeSpecies species = genome.getActiveAllele(TreeChromosomes.SPECIES);
        ILeafSpriteProvider leafSpriteProvider = species.getLeafSpriteProvider();
        ResourceLocation leafSpriteLocation = leafSpriteProvider.getSprite(false, key.fancy);
        TextureAtlasSprite leafSprite = ResourceUtil.getBlockSprite(leafSpriteLocation);
        baker.addBlockModel(leafSprite, 0);
        ResourceLocation fruitSpriteLocation = genome.getActiveAllele(TreeChromosomes.FRUITS).getProvider().getDecorativeSprite();
        if (fruitSpriteLocation != null) {
            TextureAtlasSprite fruitSprite = ResourceUtil.getBlockSprite(fruitSpriteLocation);
            baker.addBlockModel(fruitSprite, 2);
        }
        baker.setParticleSprite(leafSprite);
    }

    @Override
    protected IBakedModel bakeModel(BlockState state, Key key, BlockDecorativeLeaves block, IModelData extraData) {
        ModelBaker baker = new ModelBaker();
        this.bakeBlock(block, extraData, key, baker, false);
        this.blockModel = baker.bake(false);
        this.onCreateModel(this.blockModel);
        return this.blockModel;
    }

    public static class Key {
        public final TreeDefinition definition;
        public final boolean fancy;
        private final int hashCode;

        public Key(TreeDefinition definition, boolean fancy) {
            this.definition = definition;
            this.fancy = fancy;
            this.hashCode = Objects.hash(definition, fancy);
        }

        public boolean equals(Object other) {
            if (other == null || !(other instanceof Key)) {
                return false;
            }
            Key otherKey = (Key)other;
            return otherKey.definition == this.definition && otherKey.fancy == this.fancy;
        }

        public int hashCode() {
            return this.hashCode;
        }
    }
}

