/*
 * Decompiled with CFR 0.152.
 */
package forestry.arboriculture.models;

import forestry.api.arboriculture.IGermlingModelProvider;
import forestry.api.arboriculture.ILeafSpriteProvider;
import forestry.api.arboriculture.genetics.EnumGermlingType;
import forestry.core.utils.StringUtil;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class ModelProviderGermling
implements IGermlingModelProvider {
    private final ILeafSpriteProvider leafSpriteProvider;
    private ResourceLocation itemModel;
    private ResourceLocation blockModel;

    public ModelProviderGermling(String uid, ILeafSpriteProvider leafSpriteProvider) {
        String name = StringUtil.camelCaseToUnderscores(uid);
        this.leafSpriteProvider = leafSpriteProvider;
        this.itemModel = new ResourceLocation("forestry", "germlings/sapling." + name);
        this.blockModel = new ResourceLocation("forestry", "block/germlings/sapling." + name);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public ResourceLocation getItemModel() {
        return this.itemModel;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public ResourceLocation getBlockModel() {
        return this.blockModel;
    }

    @Override
    public int getSpriteColor(EnumGermlingType type, int renderPass) {
        if (type == EnumGermlingType.POLLEN) {
            return this.leafSpriteProvider.getColor(false);
        }
        return 0xFFFFFF;
    }
}

