/*
 * Decompiled with CFR 0.152.
 */
package forestry.arboriculture.models;

import forestry.api.arboriculture.EnumVanillaWoodType;
import forestry.api.arboriculture.IGermlingModelProvider;
import forestry.api.arboriculture.ILeafSpriteProvider;
import forestry.api.arboriculture.genetics.EnumGermlingType;
import net.minecraft.util.ResourceLocation;

public class ModelProviderGermlingVanilla
implements IGermlingModelProvider {
    private final EnumVanillaWoodType woodType;
    private final ILeafSpriteProvider leafSpriteProvider;

    public ModelProviderGermlingVanilla(EnumVanillaWoodType woodType, ILeafSpriteProvider leafSpriteProvider) {
        this.woodType = woodType;
        this.leafSpriteProvider = leafSpriteProvider;
    }

    @Override
    public int getSpriteColor(EnumGermlingType type, int renderPass) {
        if (type == EnumGermlingType.POLLEN) {
            return this.leafSpriteProvider.getColor(false);
        }
        return 0xFFFFFF;
    }

    @Override
    public ResourceLocation getItemModel() {
        switch (this.woodType) {
            case SPRUCE: {
                return new ResourceLocation("minecraft", "spruce_sapling");
            }
            case BIRCH: {
                return new ResourceLocation("minecraft", "birch_sapling");
            }
            case JUNGLE: {
                return new ResourceLocation("minecraft", "jungle_sapling");
            }
            case ACACIA: {
                return new ResourceLocation("minecraft", "acacia_sapling");
            }
            case DARK_OAK: {
                return new ResourceLocation("minecraft", "dark_oak_sapling");
            }
        }
        return new ResourceLocation("minecraft", "oak_sapling");
    }

    @Override
    public ResourceLocation getBlockModel() {
        switch (this.woodType) {
            case SPRUCE: {
                return new ResourceLocation("minecraft", "block/spruce_sapling");
            }
            case BIRCH: {
                return new ResourceLocation("minecraft", "block/birch_sapling");
            }
            case JUNGLE: {
                return new ResourceLocation("minecraft", "block/jungle_sapling");
            }
            case ACACIA: {
                return new ResourceLocation("minecraft", "block/acacia_sapling");
            }
            case DARK_OAK: {
                return new ResourceLocation("minecraft", "block/dark_oak_sapling");
            }
        }
        return new ResourceLocation("minecraft", "block/oak_sapling");
    }
}

