/*
 * Decompiled with CFR 0.152.
 */
package forestry.arboriculture.models;

import com.google.common.collect.ImmutableMap;
import com.mojang.datafixers.util.Pair;
import forestry.api.arboriculture.genetics.IAlleleTreeSpecies;
import forestry.api.arboriculture.genetics.TreeChromosomes;
import forestry.arboriculture.genetics.TreeDefinition;
import forestry.arboriculture.tiles.TileSapling;
import genetics.api.GeneticHelper;
import genetics.api.organism.IOrganism;
import genetics.utils.AlleleUtils;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.client.renderer.model.BakedQuad;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.IModelTransform;
import net.minecraft.client.renderer.model.IUnbakedModel;
import net.minecraft.client.renderer.model.ItemOverrideList;
import net.minecraft.client.renderer.model.ModelBakery;
import net.minecraft.client.renderer.model.ModelRotation;
import net.minecraft.client.renderer.model.RenderMaterial;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.IModelConfiguration;
import net.minecraftforge.client.model.data.EmptyModelData;
import net.minecraftforge.client.model.data.IModelData;
import net.minecraftforge.client.model.geometry.IModelGeometry;

public class ModelSapling
implements IModelGeometry<ModelSapling> {
    private final Map<IAlleleTreeSpecies, Pair<ResourceLocation, ResourceLocation>> modelsBySpecies = AlleleUtils.filteredStream(TreeChromosomes.SPECIES).collect(Collectors.toMap(allele -> allele, allele -> Pair.of((Object)allele.getBlockModel(), (Object)allele.getItemModel())));

    public IBakedModel bake(IModelConfiguration owner, ModelBakery bakery, Function<RenderMaterial, TextureAtlasSprite> spriteGetter, IModelTransform modelTransform, ItemOverrideList overrides, ResourceLocation modelLocation) {
        ImmutableMap.Builder itemModels = new ImmutableMap.Builder();
        ImmutableMap.Builder blockModels = new ImmutableMap.Builder();
        for (Map.Entry<IAlleleTreeSpecies, Pair<ResourceLocation, ResourceLocation>> entry : this.modelsBySpecies.entrySet()) {
            IBakedModel itemModel;
            IBakedModel blockModel = bakery.getBakedModel((ResourceLocation)entry.getValue().getFirst(), (IModelTransform)ModelRotation.X0_Y0, spriteGetter);
            if (blockModel != null) {
                blockModels.put((Object)entry.getKey(), (Object)blockModel);
            }
            if ((itemModel = bakery.getBakedModel((ResourceLocation)entry.getValue().getSecond(), (IModelTransform)ModelRotation.X0_Y0, spriteGetter)) == null) continue;
            itemModels.put((Object)entry.getKey(), (Object)itemModel);
        }
        return new Baked((Map<IAlleleTreeSpecies, IBakedModel>)itemModels.build(), (Map<IAlleleTreeSpecies, IBakedModel>)blockModels.build());
    }

    public Collection<ResourceLocation> getDependencies() {
        return this.modelsBySpecies.values().stream().flatMap(pair -> Stream.of((ResourceLocation)pair.getFirst(), (ResourceLocation)pair.getSecond())).collect(Collectors.toSet());
    }

    public Collection<RenderMaterial> getTextures(IModelConfiguration owner, Function<ResourceLocation, IUnbakedModel> modelGetter, Set<Pair<String, String>> missingTextureErrors) {
        return this.getDependencies().stream().flatMap(location -> ((IUnbakedModel)modelGetter.apply((ResourceLocation)location)).func_225614_a_(modelGetter, missingTextureErrors).stream()).collect(Collectors.toSet());
    }

    public static class Baked
    implements IBakedModel {
        private final Map<IAlleleTreeSpecies, IBakedModel> itemModels;
        private final Map<IAlleleTreeSpecies, IBakedModel> blockModels;
        private final IBakedModel defaultBlock;
        private final IBakedModel defaultItem;
        @Nullable
        private ItemOverrideList overrideList;

        public Baked(Map<IAlleleTreeSpecies, IBakedModel> itemModels, Map<IAlleleTreeSpecies, IBakedModel> blockModels) {
            this.itemModels = itemModels;
            this.blockModels = blockModels;
            this.defaultBlock = blockModels.get(TreeDefinition.Oak.getSpecies());
            this.defaultItem = itemModels.get(TreeDefinition.Oak.getSpecies());
        }

        public List<BakedQuad> getQuads(@Nullable BlockState state, @Nullable Direction side, Random rand, IModelData extraData) {
            IAlleleTreeSpecies species = (IAlleleTreeSpecies)extraData.getData(TileSapling.TREE_SPECIES);
            if (species == null) {
                species = TreeDefinition.Oak.getSpecies();
            }
            return this.blockModels.get(species).func_200117_a(state, side, rand);
        }

        public List<BakedQuad> func_200117_a(@Nullable BlockState state, @Nullable Direction side, Random rand) {
            return this.getQuads(state, side, rand, (IModelData)EmptyModelData.INSTANCE);
        }

        public boolean func_177555_b() {
            return this.defaultBlock.func_177555_b();
        }

        public boolean func_177556_c() {
            return this.defaultItem.func_177556_c();
        }

        public boolean func_230044_c_() {
            return false;
        }

        public boolean func_188618_c() {
            return false;
        }

        public TextureAtlasSprite func_177554_e() {
            return this.defaultBlock.func_177554_e();
        }

        public ItemOverrideList func_188617_f() {
            if (this.overrideList == null) {
                this.overrideList = new OverrideList();
            }
            return this.overrideList;
        }

        public class OverrideList
        extends ItemOverrideList {
            @Nullable
            public IBakedModel func_239290_a_(IBakedModel model, ItemStack stack, @Nullable ClientWorld world, @Nullable LivingEntity entity) {
                IOrganism organism = GeneticHelper.getOrganism(stack);
                if (organism.isEmpty()) {
                    return model;
                }
                IAlleleTreeSpecies species = organism.getAllele(TreeChromosomes.SPECIES, true);
                return Baked.this.itemModels.getOrDefault(species, model);
            }
        }
    }
}

