/*
 * Decompiled with CFR 0.152.
 */
package forestry.arboriculture.tiles;

import forestry.api.arboriculture.TreeManager;
import forestry.api.arboriculture.genetics.IAlleleFruit;
import forestry.api.genetics.IFruitBearer;
import forestry.api.genetics.IFruitFamily;
import forestry.api.genetics.products.IProductList;
import forestry.api.genetics.products.Product;
import forestry.arboriculture.features.ArboricultureTiles;
import forestry.arboriculture.genetics.alleles.AlleleFruits;
import forestry.core.network.IStreamable;
import forestry.core.network.PacketBufferForestry;
import forestry.core.utils.BlockUtil;
import forestry.core.utils.NBTUtilForestry;
import forestry.core.utils.RenderUtil;
import genetics.api.alleles.IAllele;
import genetics.api.individual.IGenome;
import genetics.utils.AlleleUtils;
import java.util.Optional;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.block.CocoaBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.state.Property;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class TileFruitPod
extends TileEntity
implements IFruitBearer,
IStreamable {
    private static final short MAX_MATURITY = 2;
    private static final IGenome defaultGenome = TreeManager.treeRoot.getKaryotype().getDefaultGenome();
    private static final IAlleleFruit defaultAllele = AlleleFruits.fruitCocoa;
    private IGenome genome = defaultGenome;
    private IAlleleFruit allele = defaultAllele;
    private short maturity;
    private float yield;

    public TileFruitPod() {
        super(ArboricultureTiles.PODS.tileType());
    }

    public void setProperties(IGenome genome, IAlleleFruit allele, float yield) {
        this.genome = genome;
        this.allele = allele;
        this.yield = yield;
        this.func_70296_d();
    }

    public void func_230337_a_(BlockState state, CompoundNBT compoundNBT) {
        IAllele stored;
        super.func_230337_a_(state, compoundNBT);
        Optional optionalAllele = AlleleUtils.getAllele(compoundNBT.func_74779_i("UID"));
        this.allele = !optionalAllele.isPresent() ? defaultAllele : ((stored = (IAllele)optionalAllele.get()) instanceof IAlleleFruit ? (IAlleleFruit)stored : defaultAllele);
        this.maturity = compoundNBT.func_74765_d("MT");
        this.yield = compoundNBT.func_74760_g("SP");
    }

    public CompoundNBT func_189515_b(CompoundNBT compoundNBT) {
        compoundNBT = super.func_189515_b(compoundNBT);
        compoundNBT.func_74778_a("UID", this.allele.getRegistryName().toString());
        compoundNBT.func_74777_a("MT", this.maturity);
        compoundNBT.func_74776_a("SP", this.yield);
        return compoundNBT;
    }

    public void onBlockTick(World world, BlockPos pos, BlockState state, Random rand) {
        if (this.canMature() && rand.nextFloat() <= this.yield) {
            this.addRipeness(0.5f);
        }
    }

    public boolean canMature() {
        return this.maturity < 2;
    }

    public short getMaturity() {
        return this.maturity;
    }

    public ItemStack getPickBlock() {
        IProductList products = this.allele.getProvider().getProducts();
        ItemStack pickBlock = ItemStack.field_190927_a;
        float maxChance = 0.0f;
        for (Product product : products.getPossibleProducts()) {
            if (!(maxChance < product.getChance())) continue;
            maxChance = product.getChance();
            pickBlock = product.copyStack();
        }
        pickBlock.func_190920_e(1);
        return pickBlock;
    }

    public NonNullList<ItemStack> getDrops() {
        return this.allele.getProvider().getFruits(this.genome, this.field_145850_b, this.func_174877_v(), this.maturity);
    }

    @Nullable
    public SUpdateTileEntityPacket func_189518_D_() {
        return new SUpdateTileEntityPacket(this.func_174877_v(), 0, this.func_189517_E_());
    }

    public CompoundNBT func_189517_E_() {
        CompoundNBT tag = super.func_189517_E_();
        return NBTUtilForestry.writeStreamableToNbt(this, tag);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void handleUpdateTag(BlockState state, CompoundNBT tag) {
        super.handleUpdateTag(state, tag);
        NBTUtilForestry.readStreamableFromNbt(this, tag);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void onDataPacket(NetworkManager net, SUpdateTileEntityPacket pkt) {
        super.onDataPacket(net, pkt);
        CompoundNBT nbt = pkt.func_148857_g();
        this.handleUpdateTag(this.func_195044_w(), nbt);
    }

    @Override
    public boolean hasFruit() {
        return true;
    }

    @Override
    public IFruitFamily getFruitFamily() {
        return this.allele.getProvider().getFamily();
    }

    @Override
    public NonNullList<ItemStack> pickFruit(ItemStack tool) {
        NonNullList<ItemStack> fruits = this.getDrops();
        this.maturity = 0;
        BlockState oldState = this.field_145850_b.func_180495_p(this.func_174877_v());
        BlockState newState = (BlockState)oldState.func_206870_a((Property)CocoaBlock.field_176501_a, (Comparable)Integer.valueOf(0));
        BlockUtil.setBlockWithBreakSound(this.field_145850_b, this.func_174877_v(), newState, oldState);
        return fruits;
    }

    @Override
    public float getRipeness() {
        return (float)this.maturity / 2.0f;
    }

    @Override
    public void addRipeness(float add) {
        short age;
        short previousAge = this.maturity;
        this.maturity = (short)((float)this.maturity + 2.0f * add);
        if (this.maturity > 2) {
            this.maturity = (short)2;
        }
        if ((age = this.maturity) - previousAge > 0) {
            BlockState state = (BlockState)this.field_145850_b.func_180495_p(this.func_174877_v()).func_206870_a((Property)CocoaBlock.field_176501_a, (Comparable)Integer.valueOf(age));
            this.field_145850_b.func_175656_a(this.func_174877_v(), state);
        }
    }

    @Override
    public void writeData(PacketBufferForestry data) {
        if (this.allele != defaultAllele) {
            data.func_180714_a(this.allele.getRegistryName().toString());
        } else {
            data.func_180714_a("");
        }
    }

    @Override
    public void readData(PacketBufferForestry data) {
        IAllele stored;
        Optional optionalAllele = AlleleUtils.getAllele(data.func_218666_n());
        this.allele = !optionalAllele.isPresent() ? defaultAllele : ((stored = (IAllele)optionalAllele.get()) instanceof IAlleleFruit ? (IAlleleFruit)stored : defaultAllele);
        RenderUtil.markForUpdate(this.func_174877_v());
    }
}

