/*
 * Decompiled with CFR 0.152.
 */
package forestry.arboriculture.tiles;

import com.google.common.base.Preconditions;
import forestry.api.arboriculture.TreeManager;
import forestry.api.arboriculture.genetics.ITree;
import forestry.arboriculture.genetics.Tree;
import forestry.core.network.IStreamable;
import forestry.core.network.PacketBufferForestry;
import forestry.core.owner.IOwnedTile;
import forestry.core.owner.IOwnerHandler;
import forestry.core.owner.OwnerHandler;
import forestry.core.utils.NBTUtilForestry;
import forestry.core.utils.RenderUtil;
import genetics.api.alleles.IAllele;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public abstract class TileTreeContainer
extends TileEntity
implements IStreamable,
IOwnedTile {
    @Nullable
    private ITree containedTree;
    private final OwnerHandler ownerHandler = new OwnerHandler();

    public TileTreeContainer(TileEntityType<?> p_i48289_1_) {
        super(p_i48289_1_);
    }

    public void func_230337_a_(BlockState state, CompoundNBT compoundNBT) {
        super.func_230337_a_(state, compoundNBT);
        if (compoundNBT.func_74764_b("ContainedTree")) {
            this.containedTree = new Tree(compoundNBT.func_74775_l("ContainedTree"));
        }
        this.ownerHandler.read(compoundNBT);
    }

    public CompoundNBT func_189515_b(CompoundNBT compoundNBT) {
        compoundNBT = super.func_189515_b(compoundNBT);
        if (this.containedTree != null) {
            CompoundNBT subcompound = new CompoundNBT();
            this.containedTree.write(subcompound);
            compoundNBT.func_218657_a("ContainedTree", (INBT)subcompound);
        }
        this.ownerHandler.write(compoundNBT);
        return compoundNBT;
    }

    @Override
    public void writeData(PacketBufferForestry data) {
        String speciesUID = "";
        ITree tree = this.getTree();
        if (tree != null) {
            speciesUID = tree.getIdentifier();
        }
        data.func_180714_a(speciesUID);
    }

    @Override
    public void readData(PacketBufferForestry data) {
        String speciesUID = data.func_218666_n();
        ITree tree = TileTreeContainer.getTree(speciesUID);
        this.setTree(tree);
    }

    private static ITree getTree(String speciesUID) {
        IAllele[] treeTemplate = TreeManager.treeRoot.getTemplates().getTemplate(speciesUID);
        Preconditions.checkArgument((treeTemplate.length > 0 ? 1 : 0) != 0, (String)"There is no tree template for speciesUID %s", (Object)speciesUID);
        return (ITree)TreeManager.treeRoot.templateAsIndividual(treeTemplate);
    }

    public void setTree(ITree tree) {
        this.containedTree = tree;
        if (this.field_145850_b != null && this.field_145850_b.field_72995_K) {
            RenderUtil.markForUpdate(this.func_174877_v());
        }
    }

    @Nullable
    public ITree getTree() {
        return this.containedTree;
    }

    @Override
    public IOwnerHandler getOwnerHandler() {
        return this.ownerHandler;
    }

    public abstract void onBlockTick(World var1, BlockPos var2, BlockState var3, Random var4);

    public SUpdateTileEntityPacket func_189518_D_() {
        return new SUpdateTileEntityPacket(this.func_174877_v(), 0, this.func_189517_E_());
    }

    @OnlyIn(value=Dist.CLIENT)
    public void onDataPacket(NetworkManager net, SUpdateTileEntityPacket pkt) {
        super.onDataPacket(net, pkt);
        CompoundNBT nbt = pkt.func_148857_g();
        this.handleUpdateTag(this.func_195044_w(), nbt);
    }

    public CompoundNBT func_189517_E_() {
        CompoundNBT tag = super.func_189517_E_();
        return NBTUtilForestry.writeStreamableToNbt(this, tag);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void handleUpdateTag(BlockState state, CompoundNBT tag) {
        super.handleUpdateTag(state, tag);
        NBTUtilForestry.readStreamableFromNbt(this, tag);
    }
}

