/*
 * Decompiled with CFR 0.152.
 */
package forestry.arboriculture.villagers;

import forestry.api.arboriculture.EnumForestryWoodType;
import forestry.api.arboriculture.TreeManager;
import forestry.api.arboriculture.WoodBlockKind;
import forestry.api.arboriculture.genetics.EnumGermlingType;
import forestry.api.arboriculture.genetics.IAlleleTreeSpecies;
import forestry.api.arboriculture.genetics.ITree;
import forestry.api.arboriculture.genetics.TreeChromosomes;
import forestry.arboriculture.features.ArboricultureItems;
import forestry.core.genetics.alleles.AlleleForestrySpecies;
import forestry.core.registration.VillagerTrade;
import genetics.api.alleles.IAllele;
import genetics.api.alleles.IAlleleSpecies;
import genetics.api.individual.IChromosomeAllele;
import genetics.api.organism.IOrganismType;
import genetics.utils.AlleleUtils;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.merchant.villager.VillagerProfession;
import net.minecraft.entity.merchant.villager.VillagerTrades;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.MerchantOffer;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.village.PointOfInterestType;
import net.minecraftforge.event.village.VillagerTradesEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;

public class RegisterVillager {
    public static final ResourceLocation ARBORIST = new ResourceLocation("forestry", "arborist");

    private static class GivePollenForEmeralds
    implements VillagerTrades.ITrade {
        final VillagerTrade.PriceInterval buyingPriceInfo;
        final VillagerTrade.PriceInterval sellingPriceInfo;
        final IOrganismType type;
        final int maxComplexity;
        final int maxUses;
        final int xp;
        final float priceMult;

        public GivePollenForEmeralds(VillagerTrade.PriceInterval buyingPriceInfo, VillagerTrade.PriceInterval sellingPriceInfo, IOrganismType type, int maxComplexity, int maxUses, int xp, float priceMult) {
            this.buyingPriceInfo = buyingPriceInfo;
            this.sellingPriceInfo = sellingPriceInfo;
            this.type = type;
            this.maxComplexity = maxComplexity;
            this.maxUses = maxUses;
            this.xp = xp;
            this.priceMult = priceMult;
        }

        @Nullable
        public MerchantOffer func_221182_a(Entity trader, Random rand) {
            IChromosomeAllele<IAlleleTreeSpecies> treeSpeciesType = TreeChromosomes.SPECIES;
            Collection<IAllele> registeredSpecies = AlleleUtils.getAllelesByType(treeSpeciesType);
            ArrayList<AlleleForestrySpecies> potentialSpecies = new ArrayList<AlleleForestrySpecies>();
            for (IAllele allele : registeredSpecies) {
                AlleleForestrySpecies species;
                if (!(allele instanceof AlleleForestrySpecies) || (species = (AlleleForestrySpecies)allele).getComplexity() > this.maxComplexity) continue;
                potentialSpecies.add(species);
            }
            if (potentialSpecies.isEmpty()) {
                return null;
            }
            IAlleleSpecies chosenSpecies = (IAlleleSpecies)potentialSpecies.get(rand.nextInt(potentialSpecies.size()));
            IAllele[] template = TreeManager.treeRoot.getTemplate(chosenSpecies.getRegistryName().toString());
            ITree individual = (ITree)TreeManager.treeRoot.templateAsIndividual(template);
            ItemStack sellStack = TreeManager.treeRoot.createStack(individual, this.type);
            sellStack.func_190920_e(this.sellingPriceInfo.getPrice(rand));
            return new MerchantOffer(new ItemStack((IItemProvider)Items.field_151166_bC, this.buyingPriceInfo.getPrice(rand)), sellStack, this.maxUses, this.xp, this.priceMult);
        }
    }

    private static class GiveLogsForEmeralds
    implements VillagerTrades.ITrade {
        final VillagerTrade.PriceInterval emeraldsPriceInfo;
        final VillagerTrade.PriceInterval sellingPriceInfo;
        final int maxUses;
        final int xp;
        final float priceMult;

        public GiveLogsForEmeralds(VillagerTrade.PriceInterval emeraldsPriceInfo, VillagerTrade.PriceInterval sellingPriceInfo, int maxUses, int xp, float priceMult) {
            this.emeraldsPriceInfo = emeraldsPriceInfo;
            this.sellingPriceInfo = sellingPriceInfo;
            this.maxUses = maxUses;
            this.xp = xp;
            this.priceMult = priceMult;
        }

        @Nullable
        public MerchantOffer func_221182_a(Entity trader, Random rand) {
            EnumForestryWoodType woodType = EnumForestryWoodType.getRandom(rand);
            ItemStack sellStack = TreeManager.woodAccess.getStack(woodType, WoodBlockKind.LOG, false);
            sellStack.func_190920_e(this.sellingPriceInfo.getPrice(rand));
            return new MerchantOffer(new ItemStack((IItemProvider)Items.field_151166_bC, this.emeraldsPriceInfo.getPrice(rand)), sellStack, this.maxUses, this.xp, this.priceMult);
        }
    }

    private static class GivePlanksForEmeralds
    implements VillagerTrades.ITrade {
        final VillagerTrade.PriceInterval emeraldsPriceInfo;
        final VillagerTrade.PriceInterval sellingPriceInfo;
        final int maxUses;
        final int xp;
        final float priceMult;

        public GivePlanksForEmeralds(VillagerTrade.PriceInterval emeraldsPriceInfo, VillagerTrade.PriceInterval sellingPriceInfo, int maxUses, int xp, float priceMult) {
            this.emeraldsPriceInfo = emeraldsPriceInfo;
            this.sellingPriceInfo = sellingPriceInfo;
            this.maxUses = maxUses;
            this.xp = xp;
            this.priceMult = priceMult;
        }

        @Nullable
        public MerchantOffer func_221182_a(Entity trader, Random rand) {
            EnumForestryWoodType woodType = EnumForestryWoodType.getRandom(rand);
            ItemStack sellStack = TreeManager.woodAccess.getStack(woodType, WoodBlockKind.PLANKS, false);
            sellStack.func_190920_e(this.sellingPriceInfo.getPrice(rand));
            return new MerchantOffer(new ItemStack((IItemProvider)Items.field_151166_bC, this.emeraldsPriceInfo.getPrice(rand)), sellStack, this.maxUses, this.xp, this.priceMult);
        }
    }

    @Mod.EventBusSubscriber(modid="forestry", bus=Mod.EventBusSubscriber.Bus.FORGE)
    public static class Events {
        @SubscribeEvent
        public void villagerTrades(VillagerTradesEvent event) {
            Int2ObjectMap trades = event.getTrades();
            if (ARBORIST.equals((Object)event.getType().getRegistryName())) {
                ((List)event.getTrades().get(1)).add(new GivePlanksForEmeralds(new VillagerTrade.PriceInterval(1, 4), new VillagerTrade.PriceInterval(10, 32), 8, 2, 0.0f));
                ((List)event.getTrades().get(1)).add(new GivePollenForEmeralds(new VillagerTrade.PriceInterval(1, 1), new VillagerTrade.PriceInterval(1, 3), EnumGermlingType.SAPLING, 4, 8, 2, 0.0f));
                ((List)event.getTrades().get(2)).add(new GivePlanksForEmeralds(new VillagerTrade.PriceInterval(1, 4), new VillagerTrade.PriceInterval(10, 32), 8, 6, 0.0f));
                ((List)event.getTrades().get(2)).add(new GivePollenForEmeralds(new VillagerTrade.PriceInterval(2, 3), new VillagerTrade.PriceInterval(1, 1), EnumGermlingType.POLLEN, 6, 8, 6, 0.0f));
                ((List)event.getTrades().get(2)).add(new VillagerTrade.GiveItemForEmeralds(ArboricultureItems.GRAFTER_PROVEN.getItem(), new VillagerTrade.PriceInterval(1, 1), new VillagerTrade.PriceInterval(1, 4), 8, 6));
                ((List)event.getTrades().get(3)).add(new GiveLogsForEmeralds(new VillagerTrade.PriceInterval(2, 5), new VillagerTrade.PriceInterval(6, 18), 8, 2, 0.0f));
                ((List)event.getTrades().get(3)).add(new GiveLogsForEmeralds(new VillagerTrade.PriceInterval(2, 5), new VillagerTrade.PriceInterval(6, 18), 8, 2, 0.0f));
                ((List)event.getTrades().get(4)).add(new GivePollenForEmeralds(new VillagerTrade.PriceInterval(5, 20), new VillagerTrade.PriceInterval(1, 1), EnumGermlingType.POLLEN, 10, 8, 15, 0.0f));
                ((List)event.getTrades().get(4)).add(new GivePollenForEmeralds(new VillagerTrade.PriceInterval(5, 20), new VillagerTrade.PriceInterval(1, 1), EnumGermlingType.SAPLING, 10, 8, 15, 0.0f));
            }
        }
    }

    @Mod.EventBusSubscriber(modid="forestry", bus=Mod.EventBusSubscriber.Bus.MOD)
    public static class Registers {
        public static final DeferredRegister<PointOfInterestType> POINTS_OF_INTEREST = DeferredRegister.create((IForgeRegistry)ForgeRegistries.POI_TYPES, (String)"forestry");
        public static final DeferredRegister<VillagerProfession> PROFESSIONS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.PROFESSIONS, (String)"forestry");
    }
}

